<?php
/**
 * Mobile header vertical template.
 *
 * @package Eltron
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$elements = eltron_get_theme_mod( 'header_mobile_elements_vertical_top', array() );
$count = count( $elements );

if ( 1 > $count ) {
	return;
}

$display = eltron_get_theme_mod( 'header_mobile_vertical_bar_display' );
?>
<div id="mobile-vertical-header" class="<?php echo esc_attr( implode( ' ', apply_filters( 'eltron/frontend/header_mobile_vertical_classes', array( 'eltron-header-mobile-vertical', 'eltron-header', 'eltron-popup' ) ) ) ); ?>" itemtype="https://schema.org/WPHeader" itemscope>
	<?php if ( 'drawer' === $display ) : ?>
		<div class="eltron-popup-background eltron-popup-close">
			<button class="eltron-popup-close-icon eltron-popup-close eltron-toggle"><?php eltron_icon( 'close' ); ?></button>
		</div>
	<?php endif; ?>

	<div class="eltron-header-mobile-vertical-bar eltron-header-section-vertical eltron-popup-content">
		<div class="eltron-header-mobile-vertical-bar-inner eltron-header-section-vertical-inner">
			<div class="eltron-header-section-vertical-column">
				<div class="eltron-header-mobile-vertical-bar-top eltron-header-section-vertical-row">
					<?php foreach ( $elements as $element ) eltron_header_element( $element ); ?>
				</div>
			</div>

			<?php if ( 'full-screen' === $display ) : ?>
				<button class="eltron-popup-close-icon eltron-popup-close eltron-toggle"><?php eltron_icon( 'close' ); ?></button>
			<?php endif; ?>
		</div>
	</div>
</div>