<?php
/**
 * Header search dropdown template.
 *
 * Passed variables:
 *
 * @type string $slug Header element slug.
 *
 * @package Eltron
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

?>
<div class="<?php echo esc_attr( 'eltron-header-' . $slug ); ?> eltron-header-search menu eltron-toggle-menu">
	<div class="menu-item">
		<button class="eltron-sub-menu-toggle eltron-toggle" aria-expanded="false">
			<?php eltron_icon( 'search', array( 'class' => 'eltron-menu-icon' ) ); ?>
			<span class="screen-reader-text"><?php esc_html_e( 'Search', 'eltron' ); ?></span>
		</button>
		<div class="sub-menu"><?php get_search_form(); ?></div>
	</div>
</div>