<?php
/**
 * Main header sections template.
 *
 * @package Eltron
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

?>
<div id="header" class="<?php echo esc_attr( implode( ' ', apply_filters( 'eltron/frontend/header_classes', array( 'eltron-header-main', 'eltron-header' ) ) ) ); ?>">
	<?php
	// Top Bar (if not merged)
	if ( ! intval( eltron_get_theme_mod( 'header_top_bar_merged' ) ) ) {
		eltron_main_header__bar( 'top' );
	}

	// Main Bar
	eltron_main_header__bar( 'main' );

	// Bottom Bar (if not merged)
	if ( ! intval( eltron_get_theme_mod( 'header_bottom_bar_merged' ) ) ) {
		eltron_main_header__bar( 'bottom' );
	}
	?>
</div> 