<?php
/**
 * Footer widgets section template.
 *
 * @package Eltron
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$columns = intval( eltron_get_theme_mod( 'footer_widgets_bar' ) );

if ( 1 > $columns ) {
	return;
}

$print_row = 0;
for ( $i = 1; $i <= $columns; $i++ ) {
	if ( is_active_sidebar( 'footer-widgets-' . $i ) ) {
		$print_row = true;
		break;
	}
}
?>
<div id="eltron-footer-widgets-bar" class="<?php echo esc_attr( implode( ' ', apply_filters( 'eltron/frontend/footer_widgets_bar_classes', array( 'eltron-footer-widgets-bar', 'eltron-footer-section', 'eltron-section' ) ) ) ); ?>">

<?php if ( 'yes' == eltron_get_theme_mod( 'footer_newsletter', 'no' ) ) { ?>
<div class="newsletter-section">
	<div class="container">
		<div class="newsletter-content clearfix">
			<div class="row">
				<div class="col-lg-6">
					<div class="newsletter-icon float-left">
						<i class="icon-envelope"></i>
					</div>
					<div class="newsletter-text">
						<h2><?php echo esc_html(eltron_get_theme_mod( 'newsletter_title1' ) ); ?></h2>
					</div>

				</div>
				<div class="col-lg-6">
					<div class="newsletter-form">
						<div class="newsletter-form position-relative">
							<?php echo do_shortcode(eltron_get_theme_mod( 'newsletter_content' ) ); ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<?php }
if ( 'yes' == eltron_get_theme_mod( 'ft_top_toggle', 'no' ) ) { ?>
<div class="footer-contact-info">
	<div class="container">
	<div class="row  footer-contact-info-inner">
		<div class="col-lg-3">
			<div class="footer-icon-text-contact-info headline para-content">
				<?php echo do_shortcode(eltron_get_theme_mod( 'ft_top_col_1' ) ); ?>
			</div>
		</div>
		<div class="col-lg-3">
			<div class="footer-icon-text-contact-info headline para-content">
				<?php echo do_shortcode(eltron_get_theme_mod( 'ft_top_col_2' ) ); ?>
			</div>
		</div>
		<div class="col-lg-3">
			<div class="footer-icon-text-contact-info headline para-content">
				<?php echo do_shortcode(eltron_get_theme_mod( 'ft_top_col_3' ) ); ?>
			</div>
		</div>
		<div class="col-lg-3">
			<div class="footer-icon-text-contact-info headline para-content">
				<?php echo do_shortcode(eltron_get_theme_mod( 'ft_top_col_4' ) ); ?>
			</div>
		</div>
	</div>
<div class="ft-border"></div>
	</div>
</div>
<?php } ?>


	<div class="eltron-footer-widgets-bar-inner eltron-section-inner">
		<div class="eltron-wrapper">
			<?php if ( $print_row ) : ?>
				<div class="eltron-footer-widgets-bar-row <?php echo esc_attr( 'eltron-footer-widgets-bar-columns-' . eltron_get_theme_mod( 'footer_widgets_bar' ) ); ?>">
					<?php for ( $i = 1; $i <= $columns; $i++ ) : ?>
						<div class="eltron-footer-widgets-bar-column-<?php echo esc_attr( $i ); ?> eltron-footer-widgets-bar-column">
							<?php if ( is_active_sidebar( 'footer-widgets-' . $i ) ) {
								dynamic_sidebar( 'footer-widgets-' . $i );
							} ?>
						</div>
					<?php endfor; ?>
				</div>
			<?php endif; ?>

			<?php
			// Bottom Bar (if merged)
			if ( intval( eltron_get_theme_mod( 'footer_bottom_bar_merged' ) ) ) {
				eltron_footer_bottom();
			}
			?>

		</div>
	</div>
</div>