<?php
/**
 * Page entry template.
 *
 * @package Eltron
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

?>
<article id="page-<?php the_ID(); ?>" <?php post_class( apply_filters( 'eltron/frontend/entry/page_classes', array( 'entry', 'entry-page', 'entry-layout-default' ) ) ); ?> role="article">
	<div class="entry-wrapper">
		<?php
		/**
		 * Hook: eltron/frontend/entry/before_header
		 *
		 * @hooked eltron_entry_featured_media - 10
		 */
		do_action( 'eltron/frontend/entry/before_header' );
		
		if ( has_action( 'eltron/frontend/entry/header' ) ) :
		?>
			<header class="entry-header <?php echo esc_attr( 'eltron-text-align-' . eltron_get_theme_mod( 'entry_header_alignment' ) ); ?>">
				<?php
				/**
				 * Hook: eltron/frontend/entry/header
				 *
				 * @hooked eltron_entry_title - 10
				 */
				do_action( 'eltron/frontend/entry/header' );
				?>
			</header>
		<?php
		endif;

		/**
		 * Hook: eltron/frontend/entry/after_header
		 */
		do_action( 'eltron/frontend/entry/after_header' );
		?>

		<div class="entry-content">
			<?php
			/**
			 * Hook: eltron/frontend/entry/before_content
			 */
			do_action( 'eltron/frontend/entry/before_content' );

			/**
			 * Excerpt
			 */

			the_content();

			// Content pagination (if exists)
			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'eltron' ),
				'after'  => '</div>',
			) );

			/**
			 * Hook: eltron/frontend/entry/after_content
			 */
			do_action( 'eltron/frontend/entry/after_content' );
			?>
		</div>

		<?php
		/**
		 * Hook: eltron/frontend/entry/before_footer
		 */
		do_action( 'eltron/frontend/entry/before_footer' );
		
		if ( has_action( 'eltron/frontend/entry/footer' ) ) :
		?>
			<footer class="entry-footer <?php echo esc_attr( 'eltron-text-align-' . eltron_get_theme_mod( 'entry_footer_alignment' ) ); ?>">
				<?php
				/**
				 * Hook: eltron/frontend/entry/footer
				 */
				do_action( 'eltron/frontend/entry/footer' );
				?>
			</footer>
		<?php
		endif;

		/**
		 * Hook: eltron/frontend/entry/after_footer
		 */
		do_action( 'eltron/frontend/entry/after_footer' );
		?>
	</div>
</article>
