<?php
/**
 * The sidebar containing the main widget area.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Eltron
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

// Get current page content layout, skip sidebar if not needed in the layout.
if ( ! in_array( eltron_get_current_page_setting( 'content_layout' ), array( 'left-sidebar', 'right-sidebar' ) ) ) return;

if ( is_active_sidebar( 'sidebar' ) ) :

?>
<aside id="secondary" class="<?php echo esc_attr( implode( ' ', apply_filters( 'eltron/frontend/sidebar_classes', array( 'widget-area', 'sidebar' ) ) ) ); ?>" role="complementary" itemtype="https://schema.org/WPSideBar" itemscope>
	<?php
	/**
	 * Hook: eltron/frontend/before_sidebar
	 */
	do_action( 'eltron/frontend/before_sidebar' );
	
	?>
		<div class="sidebar-inner">
			<?php dynamic_sidebar( 'sidebar' ); ?>
		</div>
	<?php

	/**
	 * Hook: eltron/frontend/after_sidebar
	 */
	do_action( 'eltron/frontend/after_sidebar' );
	?>
</aside>

<?php
endif;

