<?php
/**
 * The template for displaying search results pages.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package Eltron
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Header
 */
get_header();

/**
 * Primary - opening tag
 */
eltron_primary_open();

/**
 * Hook: eltron/frontend/before_main
 *
 * @hooked eltron_search_header - 10
 */
do_action( 'eltron/frontend/before_main' );

if ( have_posts() ) :
	
	?>
	<div id="loop" class="eltron-loop eltron-loop-search">
		<?php
		// Start the loop.
		while ( have_posts() ) : the_post();

			// Render post content using "content-search" layout on Customizer.
			eltron_get_template_part( 'entry', 'search' );

		endwhile;
		?>
	</div>
	<?php

else :

	// Render no content notice.
	eltron_get_template_part( 'entry', 'none' );

endif;

/**
 * Hook: eltron/frontend/after_main
 * 
 * @hooked eltron_loop_navigation - 10
 */
do_action( 'eltron/frontend/after_main' );

/**
 * Primary - closing tag
 */
eltron_primary_close();

/**
 * Sidebar
 */
get_sidebar();

/**
 * Footer
 */
get_footer();