<?php
/**
 * Template Name: Page with Sidebar
 *
 * Page template for displaying content with sidebar
 *
 * @package Eltron
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Header
 */
get_header();

/**
 * Primary - opening tag
 */
eltron_primary_open();

/**
 * Hook: eltron/frontend/before_main
 */
do_action( 'eltron/frontend/before_main' );

while ( have_posts() ) : the_post();

	// Render post content using "content-page" layout.
	eltron_get_template_part( 'entry', 'page' );

endwhile;

/**
 * Hook: eltron/frontend/after_main
 */
do_action( 'eltron/frontend/after_main' );

/**
 * Primary - closing tag
 */
eltron_primary_close();

/**
 * Sidebar
 */
get_sidebar();

/**
 * Footer
 */
get_footer();