<?php
if ( ! defined( 'ABSPATH' ) ) exit;

/*-----------------------------------------------------------------------------------*/
/* Theme Settings! */
/*-----------------------------------------------------------------------------------*/

add_action( 'customize_register', 'eltron_general_settings' );

if( ! function_exists( 'eltron_general_settings' ) ) {

function eltron_general_settings( $wp_customize ) {

		if( class_exists( 'Eltron_Customizer' ) ) {

			$defaults = apply_filters( 'eltron/customizer/setting_defaults', array() );

			/* Section General Settings */
			$wp_customize->add_section( 'eltron_section_general_settings', array(
			    'title'       => esc_html__( 'General Eltron Settings', 'eltron' ),
			    'description' => '<p>' . esc_html__( 'Some additional header options.', 'eltron' ) . '</p>',
			    'priority'    => 1,
			) );
			$section = 'eltron_section_general_settings';

			// Custom look settings
			$key = 'custom_look';
			// Heading
			$wp_customize->add_control( new Eltron_Customize_Control_Heading( $wp_customize, $key.'eltron_title', array(
				'section'     => $section,
				'settings'    => array(),
				'label'       => esc_html__( 'Eltron layout settings', 'eltron' ),
			) ) );
			$wp_customize->add_setting( $key, array(
				'default'     => '',
				'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'select' ),
			) );
			$wp_customize->add_control( $key, array(
				'type'        => 'select',
				'section'     => $section,
				'label'       => esc_html__( 'Eltron Layout.', 'eltron' ),
				'description'       => esc_html__( 'Please note that all other Blog layout, Single blog layout settings found in other setting panels will not work if you choose Eltron special layout here. Browser reload required after change. Eltron has some special layout related stuff applied on Blog, Single post and Footer on cost of flexibility of settings provided in customizer. In case you want flexibility to change, switch to Default here. Actual content like widgets or Post data remain unchanged, only design/layout changes.', 'eltron' ),
				'default'       => 'eltron_special',
				'choices'     => array(
					'eltron_special'    => esc_html__( 'Eltron Special', 'eltron' ),
					'default'           => esc_html__( 'Default', 'eltron' ),
				),
			) );

			// Single blog header.
			$key = 'single_blog_hdr';
			$wp_customize->add_control( new Eltron_Customize_Control_Heading( $wp_customize, $key.'eltron_title', array(
				'section'     => $section,
				'settings'    => array(),
				'label'       => esc_html__( 'Single blog header', 'eltron' ),
			) ) );
			$wp_customize->add_setting( $key, array(
				'default'     => true,
				'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'toggle' ),
			) );
			$wp_customize->add_control( new Eltron_Customize_Control_Toggle( $wp_customize, $key, array(
				'section'     => $section,
				'label'       => esc_html__( 'One word page-header', 'eltron' ),
				'description' => esc_html__( 'By default, Blog appears on single blog page, disable this to display full post title instead.', 'eltron' ),
			) ) );


			/* Footer settings */
$panel      = 'eltron_panel_footer';
$section    = '';
$section    = 'eltron_section_footer_top';
// Footer Builder
$wp_customize->add_section( $section, array(
    'title'    => esc_html__( 'Footer Top', 'eltron' ),
    'panel'    => $panel,
    'priority' => 10,
) );

			// Select footer newsletter
			$key = 'footer_newsletter';
			$wp_customize->add_setting( $key, array(
				'default'     => eltron_array_value( $defaults, $key ),
				'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'select' ),
			) );
			$wp_customize->add_control( $key, array(
				'type'        => 'select',
				'section'     => $section,
				'label'       => esc_html__( 'Enable footer newseletter', 'eltron' ),
				'description' => esc_html__( 'If you want to have newsletter in the footer, please do required here.', 'eltron' ),
				'choices'     => array(
					'no'  => esc_html__( 'No', 'eltron' ),
					'yes' => esc_html__( 'Yes', 'eltron' ),
				),
			) );
			// Newsletter title
			$key = 'newsletter_title1';
			$wp_customize->add_setting( $key, array(
				'default'     => eltron_array_value( $defaults, $key ),
				'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'text' ),
			) );
			$wp_customize->add_control( $key, array(
				'section'     => $section,
				'label'       => esc_html__( 'Newsletter Title', 'eltron' ),
				'input_attrs' => array(
					'placeholder' => esc_html__( 'Signup to our', 'eltron' ),
				),
			) );
			// Newsletter content
			$key = 'newsletter_content';
			$wp_customize->add_setting( $key, array(
				'default'     => eltron_array_value( $defaults, $key ),
				'transport'   => 'postMessage',
				'sanitize_callback' => false,
			) );
			$wp_customize->add_control( $key, array(
				'type'        => 'textarea',
				'section'     => $section,
				'label' => esc_html__( 'Enter your mailchimp code.', 'eltron' ),
				'description' => esc_html__( 'You can get it from Mailchimp list > Signup forms > Embedded Forms > Naked. Please make sure to check the Only Required Fields only checkbox on left, And then copy the code provided on bottom right of page please.', 'eltron' ),
				'priority'    => 10,
			) );


			// Footer top settings
			$key = 'ft_top_toggle';
			$wp_customize->add_setting( $key, array(
				'default'     => eltron_array_value( $defaults, $key ),
				'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'select' ),
			) );
			$wp_customize->add_control( $key, array(
				'type'        => 'select',
				'section'     => $section,
				'label'       => esc_html__( 'Enable footer top bar', 'eltron' ),
				'description' => esc_html__( 'If you want to have content bar on footer top with 4 columns as seen in demo, enable here.', 'eltron' ),
				'choices'     => array(
					'no'  => esc_html__( 'No', 'eltron' ),
					'yes' => esc_html__( 'Yes', 'eltron' ),
				),
			) );
			// Column 1 content
			$key = 'ft_top_col_1';
			$wp_customize->add_setting( $key, array(
				'default'     => eltron_array_value( $defaults, $key ),
				'transport'   => 'postMessage',
				'sanitize_callback' => false,
			) );
			$wp_customize->add_control( $key, array(
				'type'        => 'textarea',
				'section'     => $section,
				'label' => esc_html__( 'Column 1 content.', 'eltron' ),
				'priority'    => 10,
			) );
			// Column 2 content
			$key = 'ft_top_col_2';
			$wp_customize->add_setting( $key, array(
				'default'     => eltron_array_value( $defaults, $key ),
				'transport'   => 'postMessage',
				'sanitize_callback' => false,
			) );
			$wp_customize->add_control( $key, array(
				'type'        => 'textarea',
				'section'     => $section,
				'label' => esc_html__( 'Column 2 content.', 'eltron' ),
				'priority'    => 10,
			) );
			// Column 3 content
			$key = 'ft_top_col_3';
			$wp_customize->add_setting( $key, array(
				'default'     => eltron_array_value( $defaults, $key ),
				'transport'   => 'postMessage',
				'sanitize_callback' => false,
			) );
			$wp_customize->add_control( $key, array(
				'type'        => 'textarea',
				'section'     => $section,
				'label' => esc_html__( 'Column 3 content.', 'eltron' ),
				'priority'    => 10,
			) );
			// Column 4 content
			$key = 'ft_top_col_4';
			$wp_customize->add_setting( $key, array(
				'default'     => eltron_array_value( $defaults, $key ),
				'transport'   => 'postMessage',
				'sanitize_callback' => false,
			) );
			$wp_customize->add_control( $key, array(
				'type'        => 'textarea',
				'section'     => $section,
				'label' => esc_html__( 'Column 4 content.', 'eltron' ),
				'priority'    => 10,
			) );



			/* Display notices on various places for theme specific blog template */
			$section = '';
			$sections = array(
				'eltron_section_blog_index',
				'eltron_section_entry_default',
				'eltron_section_entry_grid',
				'eltron_section_page_settings_post_singular',
				'eltron_section_page_settings_post_archive',
				'eltron_section_blog_single',
			);
			foreach( $sections as $section ) {
				// Notice Dynamic Page Settings
				$wp_customize->add_control( new Eltron_Customize_Control_Blank( $wp_customize, $section.'_notice', array(
					'section'     => $section,
					'settings'    => array(),
					'priority'    => '0',
					'description' => '<div class="notice notice-info notice-alt inline"><p>' . sprintf(
						/* translators: %1$s: section name, %2$s: link to Dynamic Page Settings. */
							esc_html__( 'Please note that below settings only work if you have Default Layout option selected in %1$s', 'eltron' ),
							'<a href="' . esc_url( add_query_arg( 'autofocus[section]', 'eltron_section_general_settings', remove_query_arg( 'autofocus' ) ) ) . '" class="eltron-customize-goto-control">' . esc_html__( 'General Settings.', 'eltron' ) . '</a>'
						) . '</p></div>',
				) ) );
			}

		}

	}

}