<?php
/**
 * Hotel plugin settings.
 *
 */

remove_action( 'mphb_render_single_room_type_metas', array( '\MPHB\Views\SingleRoomTypeView', 'renderCalendar' ), 40 );
remove_action( 'mphb_render_single_room_type_metas', array( '\MPHB\Views\SingleRoomTypeView', 'renderReservationForm' ), 50 );

if ( ! function_exists( 'eltron_single_room_attr' ) ) {
	function eltron_single_room_attr() {

	// Enable calendar.
	if ( eltron_get_theme_mod('enable_avail_cal', '0') ) {
		add_action( 'mphb_render_single_room_type_metas', array( '\MPHB\Views\SingleRoomTypeView', 'renderCalendar' ), 40 );
	}

	// Enable reserve form.
	if ( eltron_get_theme_mod('enable_reserve_form', '0') ) {
		add_action( 'mphb_render_single_room_type_metas', array( '\MPHB\Views\SingleRoomTypeView', 'renderReservationForm' ), 50 );
	}


	} // End eltron_single_room_attr()
}


/**
 * Add more rooms on single room bottom.
 */
if(!( function_exists('eltron_single_footer_rooms') )) {
	function eltron_single_footer_rooms() {

		if( ! is_singular('mphb_room_type') ) return; /* Run below code only on rooms */

		if( eltron_get_theme_mod('single_room_list', '1') ) {
			echo do_shortcode( '[tt_vc_add_content_shortcode posts_per_page="'.eltron_get_theme_mod('num_rooms', '3').'" post_type="mphb_room_type" tt_template="'.eltron_get_theme_mod('room_template', 'rooms-modern').'" spl_link="'.eltron_get_theme_mod('btn_link', '').'" spl_button="'.eltron_get_theme_mod('btn_text', '').'" spl_title="'.eltron_get_theme_mod('single_room_title', 'View All').'"]' );
			echo '<div class=mbottom10></div>';
		}

	}

	add_action( 'eltron/frontend/before_footer', 'eltron_single_footer_rooms', 2 );
}

/**
 * Add CTA on single room bottom.
 */
if(!( function_exists('eltron_cta_footer_rooms') )) {
	function eltron_cta_footer_rooms() {

		if( ! is_singular('mphb_room_type') ) return; /* Run below code only on rooms */
		if( ! eltron_get_theme_mod('single_room_cta', '1') ) return; /* user disabled */
		ob_start();
?>

		<section class="roomcta">
			<div class="thm-container">
				<div class="row">

					<div class="col-md-12">
						<span><?php echo wp_kses_post( eltron_get_theme_mod('single_room_cta_cont', '')); ?></span>
					</div><!-- /.col-md-12 -->

				</div><!-- /.row -->
			</div><!-- /.thm-container -->
		</section>

<?php
		echo ob_get_clean();
	}
	add_action( 'eltron/frontend/before_footer', 'eltron_cta_footer_rooms', 1 );
}


/**
 * Adding catIcon Field
 * @return void
 */
function eltron_mphb_room_type_facility_add_caticon( $term ) {

	?>
	<div class="form-field">
		<label for="taxIcon"><?php _e( 'Amenity Icon', 'eltron' ); ?></label>

		<input type="text" name="taxIcon" id="taxIcon" value="">
		<p class="description"><?php esc_html_e('These icons are used in special list style of rooms for hover source for this Amenity. Optional if you are not using List style 2 for rooms. You can get list of available icons from this link https://fontawesome.com/v4.7.0/icons/ Enter code without fa-, for example, if you want to add snowflake icon, you would add snowflake-o in above field.', 'eltron'); ?></p>
	</div>
<?php
}
add_action( 'mphb_room_type_facility_add_form_fields', 'eltron_mphb_room_type_facility_add_caticon', 10, 2 );


/**
 * Edit catIcon Field
 * @return void
 */
function eltron_mphb_room_type_facility_edit_caticon( $term ) {

	// put the term ID into a variable
	$t_id = $term->term_id;

	$term_caticon = get_term_meta( $t_id, 'caticon', true );
	?>
	<tr class="form-field">
		<th><label for="taxIcon"><?php _e( 'Amenity Icon', 'eltron' ); ?></label></th>

		<td>
			<input type="text" name="taxIcon" id="taxIcon" value="<?php echo esc_attr( $term_caticon ) ? esc_attr( $term_caticon ) : ''; ?>">
		<p class="description"><?php esc_html_e('These icons are used in special list style of rooms for hover source for this Amenity. Optional if you are not using List style 2 for rooms. You can get list of available icons from this link https://fontawesome.com/v4.7.0/icons/ Enter code without fa-, for example, if you want to add snowflake icon, you would add snowflake-o in above field.', 'eltron'); ?></p>
		</td>
	</tr>
<?php
}
add_action( 'mphb_room_type_facility_edit_form_fields', 'eltron_mphb_room_type_facility_edit_caticon', 10 );


/**
 * Saving catIcon
 */
function eltron_mphb_room_type_facility_save_caticon( $term_id ) {

	if ( isset( $_POST['taxIcon'] ) ) {
		$term_caticon = $_POST['taxIcon'];
		if( $term_caticon ) {
			 update_term_meta( $term_id, 'caticon', $term_caticon );
		}
	}

}
add_action( 'edited_mphb_room_type_facility', 'eltron_mphb_room_type_facility_save_caticon' );
add_action( 'create_mphb_room_type_facility', 'eltron_mphb_room_type_facility_save_caticon' );

