<?php
/**
 * Eltron setup
 *
 * @package eltron
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Elementor\Controls_Manager;
add_filter('eltron_add_contents_fields', 'eltron_theme_contents_fields');

function eltron_theme_contents_fields() {

		$contents_type_fields = [
			'label' => sprintf( esc_html__( '%1$s Add Content', 'eltron' ), ucfirst(get_template() ) ),
			'controls' => [
				'posts_per_page' => [
					'label' => esc_html__( 'Number of posts displayed', 'eltron' ),
					'type' => Controls_Manager::TEXT,
					'default' => '5',
					'description' => esc_html__( 'The number of posts you want to show.', 'eltron' ),
					'label_block' => true,
				],
				'post_type' => [
					'label' => esc_html__( 'Content Type', 'eltron' ),
					'type' => Controls_Manager::SELECT,
					'description' =>esc_html__( 'Not all content type will be listed here. We list only those we have template in this theme for.', 'eltron' ),
					'default'  => 'post',
					'options'  => [
						 'post'                 => esc_html__(' Posts', 'eltron'),
						 'tt_portfolio'           => esc_html__(' Gallery/Portfolio', 'eltron'),
					],
				],

				'orderby' => [
					'label' => esc_html__( 'Order by', 'eltron' ),
					'type' => Controls_Manager::SELECT,
					'description' =>esc_html__( 'Order this content by...', 'eltron' ),
					'default'  => 'date',
					'options'  => [
						  'date'            =>      esc_html__(' Date', 'eltron'),
						  'ID'              =>      esc_html__(' Post ID', 'eltron'),
						  'author'          =>      esc_html__(' Author', 'eltron'),
						  'title'           =>      esc_html__(' Title', 'eltron'),
						  'name'            =>      esc_html__(' Post name (post slug)', 'eltron'),
						  'modified'        =>      esc_html__(' Last modified date', 'eltron'),
						  'rand'            =>      esc_html__(' Random order', 'eltron'),
						  'comment_count'   =>      esc_html__(' Number of comments', 'eltron'),
					],
				],

				'order' => [
					'label' => esc_html__( 'Order', 'eltron' ),
					'type' => Controls_Manager::SELECT,
					'default'  => 'DESC',
					'options'  => [
						  'DESC'            =>      esc_html__(' DESC', 'eltron'),
						  'ASC'             =>      esc_html__(' ASC', 'eltron'),
					],
				],

				'tt_id' => [
					'label' => esc_html__( 'Post Ids', 'eltron' ),
					'type' => Controls_Manager::TEXT,
					'default' => '',
					'description' => esc_html__( 'If you want to display particular posts, enter their IDs comma separated. eg 101,202,300. Recommended: Leave blank', 'eltron' ),
					'label_block' => true,
				],

				'tt_template' => [
					'label' => esc_html__( 'Display Template', 'eltron' ),
					'type' => Controls_Manager::SELECT,
					'description' => esc_html__( 'There are prebuilt templates to display certain content in this theme. You are requested not to edit this.', 'eltron' ),
					'default'  => 'default',
					'options'  => [
						'default'                   =>  esc_html__(' Default', 'eltron'),
						'blog-grid'                 =>  esc_html__(' Blog Grid', 'eltron'),
						'portfolio-masonry'         =>  esc_html__(' Portfolio', 'eltron'),
					],
				],

				'enable_filter' => [
					'label' => esc_html__( 'Enable Filter ?', 'eltron' ),
					'type' => Controls_Manager::SWITCHER,
					'description' => esc_html__( 'If set to yes, the gallery is filterable by the category. Not applicable to all cases.', 'eltron' ),
					'default' => 'true',
					'prefix_class' => 'elementor-',
					'label_on' => 'Yes',
					'label_off' => 'No',
					'return_value' => 'true',
					'condition' => [
						'tt_template' => [ 'portfolio-masonry' ],
					],
				],

				'enable_all_btn' => [
					'label' => esc_html__( 'Enable ALL button ?', 'eltron' ),
					'type' => Controls_Manager::SWITCHER,
					'description' => esc_html__( 'If set to yes, All link appears first that displays all items. Not applicable to all cases.', 'eltron' ),
					'default' => 'true',
					'prefix_class' => 'elementor-',
					'label_on' => 'Yes',
					'label_off' => 'No',
					'return_value' => 'true',
					'condition' => [
						'tt_template' => [ 'portfolio-masonry' ],
					],
				],
				/* The param name should not be changed. */
				/* spl_title */
				'spl_field1' => [
					'label' => esc_html__( 'Title (Optional)', 'eltron' ),
					'type' => Controls_Manager::TEXT,
					'description' => esc_html__( 'Enter the title for the entire block. Leave blank to disable.', 'eltron' ),
					'label_block' => true,
					'condition' => [
						'tt_template' => [ 'portfolio-masonry', 'default', 'blog-grid' ],
					],
				],
				/* spl_button */
				'spl_field2' => [
					"label" => esc_html__("Button Label (Optional)", 'eltron'),
					'type' => Controls_Manager::TEXT,
					'description' => esc_html__( 'Leave blank to disable button.', 'eltron' ),
					'label_block' => true,
					'condition' => [
						'tt_template' => [ 'portfolio-masonry', 'default' ],
					],
				],
				/* spl_target */
				'spl_field3' => [
					"label" => esc_html__("Open links in:",'eltron'),
					'type' => Controls_Manager::SELECT,
					'label_block' => true,
					'options'  => [
						'_self'           =>  esc_html__(' Same window', 'eltron'),
						'_blank'   =>  esc_html__(' New window', 'eltron'),
					],
					'condition' => [
						'tt_template' => [ 'portfolio-masonry', 'default' ],
					],
				],
				/* spl_link */
				'spl_field4' => [
					"label" => esc_html__("Button Link:",'eltron'),
					'type' => Controls_Manager::TEXT,
					'description' => esc_html__( 'The link for the above button.', 'eltron' ),
					'label_block' => true,
					'condition' => [
						'tt_template' => [ 'portfolio-masonry', 'default' ],
					],
				],
				/* spl_subtitle */
				'spl_field5' => [
					'label' => esc_html__( 'Subtitle (Optional)', 'eltron' ),
					'type' => Controls_Manager::TEXT,
					'description' => esc_html__( 'Enter the subtitle for the entire block. Leave blank to disable.', 'eltron' ),
					'label_block' => true,
					'condition' => [
						'tt_template' => [ 'portfolio-masonry', 'default', 'blog-grid' ],
					],
				],
				/* spl_desc */
				'spl_field6' => [
					'label' => esc_html__( 'Description (Optional)', 'eltron' ),
					'type' => Controls_Manager::TEXTAREA,
					'description' => esc_html__( 'Enter the description for the entire block. Leave blank to disable. Plain text only, new line or html will not work.', 'eltron' ),
					'label_block' => true,
					'condition' => [
						'tt_template' => [ 'default', 'blog-grid' ],
					],
				],

			],
		];

		return $contents_type_fields;

}
