<?php
/**
 * The template for displaying all single posts.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Eltron
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Header
 */
get_header();

/**
 * Primary - opening tag
 */
eltron_primary_open();

/**
 * Hook: eltron/frontend/before_main
 */
do_action( 'eltron/frontend/before_main' );

while ( have_posts() ) : the_post();

	// Render post content using "content" layout.
	?>

	<!-- Start of blog details section
		============================================= -->
		<section id="blog-details" class="blog-page-area-section blog-details-page">
				<div class="row">
					<div <?php post_class('col-lg-12 col-md-12'); ?>>
						<div class="blog-details-content">
							<div class="blog-page-post-item">
								<div class="blog-post-thumbnail-text para-content headline">
									<?php if( has_post_thumbnail() ) { ?>
									<div class="blog-post-thumb-img position-relative">
										<?php the_post_thumbnail(); ?>
										<div class="blog-category text-uppercase">
											<?php echo eltron_blv_get_cats('single'); ?>
										</div>
									</div>
									<?php } ?>
									<div class="blog-post-meta">
										<a class="meta" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"><i class="far fa-user"></i><?php echo get_the_author_meta( 'nicename', get_the_author_meta( 'ID' ) ); ?></a>
										<span class="meta"> <i class="far fa-calendar-alt"></i><?php echo get_the_date(); ?></span>
											<?php
											if ( comments_open() || get_comments_number() ) { ?>
												<a class="meta" href="#comments"><i class="far fa-comment"></i><?php esc_html_e('Comments ', 'eltron'); ?>(<?php echo get_comments_number($post->ID); ?>)</a>
											<?php } ?>
									</div>
								</div>
							</div>
							<div class="blog-details-text-content headline clearfix">
								<?php the_title( '<h2 class="posttitle-single">', '</h2>' ); ?>
								<?php
									// If it's included in a single post page.
									if ( is_single() ) {
										// Print the content.
										echo '<div class="blv-clr entry-content">';
										the_content();
										echo '</div>';

										// Print content pagination, if exists.
										wp_link_pages( array(
											'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'eltron' ),
											'after'  => '</div>',
										) );
									}
									// If it's included in a posts archive page.
									else {
										echo '<div class="blv-clr entry-content">';
										the_excerpt();
										echo '</div>';
									}
								?>
							</div>
						</div>
					</div>
				</div>
		</section>
	<!-- End of blog details section
		============================================= -->

<?php
endwhile;

		if ( has_action( 'eltron/frontend/entry/footer' ) ) :
		?>
			<footer class="entry-footer <?php echo esc_attr( 'eltron-text-align-' . eltron_get_theme_mod( 'entry_footer_alignment' ) ); ?>">
				<?php
				/**
				 * Hook: eltron/frontend/entry/footer
				 *
				 * @hooked eltron_entry_footer_meta - 10
				 */
				do_action( 'eltron/frontend/entry/footer' );
				?>
			</footer>
		<?php
		endif;

/**
 * Hook: eltron/frontend/after_main
 *
 * @hooked eltron_single_post_author_bio - 10
 * @hooked eltron_single_post_navigation - 15
 * @hooked eltron_entry_comments - 20
 */
do_action( 'eltron/frontend/after_main' );

/**
 * Primary - closing tag
 */
eltron_primary_close();

/**
 * Sidebar
 */
get_sidebar();

/**
 * Footer
 */
get_footer();