<?php
/**
 * @package eltron
 */
?>

<div <?php post_class('col-lg-12 col-md-12'); ?>>
	<div class="blog-page-post-item">
		<div class="blog-post-thumbnail-text headline">
			<?php if( has_post_thumbnail() ) { ?>
				<div class="blog-post-thumb-img position-relative">
					<?php the_post_thumbnail(); ?>
					<div class="blog-category text-uppercase">
						<?php echo eltron_blv_get_cats('single'); ?>
					</div>
				</div>
			<?php } ?>
			<div class="blog-post-meta">
			<a class="meta" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>">
				<i class="far fa-user"></i>
				<?php echo get_the_author_meta( 'nicename', get_the_author_meta( 'ID' ) ); ?>
			</a>
			<span class="meta"> <i class="far fa-calendar-alt"></i><?php echo get_the_date(); ?></span>
					<?php
					if ( comments_open() || get_comments_number() ) { ?>
						<a class="meta" href="#comments"><i class="far fa-comment"></i><?php esc_html_e('Comments ', 'eltron'); ?>(<?php echo get_comments_number($post->ID); ?>)</a>
					<?php } ?>
			</div>
			<div class="blog-post-text">
				<?php the_title( sprintf( '<h3 class="posttitle"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
				<?php
					// If it's included in a single post page.
					if ( is_single() ) {
						// Print the content.
						echo '<div class="blv-clr entry-content">';

						the_content();

						// Print content pagination, if exists.
						wp_link_pages( array(
							'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'eltron' ),
							'after'  => '</div>',
						) );

						echo '</div>';
					}
					// If it's included in a posts archive page.
					else {
						echo '<div class="blv-clr entry-content">';
						the_excerpt();
						echo '</div>';
					}
				?>
				<div class="excerpt-more">
					<a href="<?php the_permalink(); ?>"><?php esc_html_e('FULL STORY', 'eltron'); ?>
						<img src="<?php echo get_template_directory_uri(); ?>/assets/img/arrow2.png" alt="<?php esc_html_e('arrow', 'eltron'); ?>" />
					</a>
				</div>
			</div>
		</div>
		<!-- /post-item-list -->
	</div>
</div>


