<?php
if ( ! defined( 'ABSPATH' ) ) exit;

/*-----------------------------------------------------------------------------------*/
/* Theme additional enqueue! */
/*-----------------------------------------------------------------------------------*/

/* Enable this file in parent init.php file if needed. */

function eltron_scripts() {

			/**
			 * Styles
			 */

    wp_enqueue_style( 'owlcarousel', get_template_directory_uri() . '/assets/css/owl.carousel.css', false, null, 'all');
    wp_enqueue_style( 'fontawesomeall', get_template_directory_uri() . '/assets/css/fontawesome-all.css', false, null, 'all');
    wp_enqueue_style( 'simplelineicons', get_template_directory_uri() . '/assets/css/simple-line-icons.css', false, null, 'all');
    wp_enqueue_style( 'animate', get_template_directory_uri() . '/assets/css/animate.css', false, null, 'all');
    wp_enqueue_style( 'flaticon', get_template_directory_uri() . '/assets/css/flaticon.css', false, null, 'all');
    wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/assets/css/bootstrap.min.css', false, null, 'all');
    wp_enqueue_style( 'video', get_template_directory_uri() . '/assets/css/video.min.css', false, null, 'all');
    wp_enqueue_style( 'lightbox', get_template_directory_uri() . '/assets/css/lightbox.css', false, null, 'all');
    wp_enqueue_style( 'eltron-style', get_template_directory_uri() . '/assets/css/style.css', false, null, 'all');
	wp_enqueue_style( 'eltron-style', get_template_directory_uri() . '/style.css', '', ELTRON_VERSION );
	wp_style_add_data( 'eltron-style', 'rtl', 'replace' );


			/**
			 * Scripts
			 */
			$suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';


    wp_enqueue_script( 'bootstrap', get_template_directory_uri() . '/assets/js/bootstrap.min.js',  array('jquery'), null, true);
    wp_enqueue_script( 'popper', get_template_directory_uri() . '/assets/js/popper.min.js',  array('jquery'), null, true);
    wp_enqueue_script( 'owlcarousel', get_template_directory_uri() . '/assets/js/owl.carousel.min.js',  array('jquery'), null, true);
    wp_enqueue_script( 'jarallax', get_template_directory_uri() . '/assets/js/jarallax.js',  array('jquery'), null, true);
    wp_enqueue_script( 'jquerymagnificpopup', get_template_directory_uri() . '/assets/js/jquery.magnific-popup.min.js',  array('jquery'), null, true);
    wp_enqueue_script( 'appear', get_template_directory_uri() . '/assets/js/appear.js',  array('jquery'), null, true);
    wp_enqueue_script( 'imagesloaded' );
    wp_enqueue_script( 'masonrypkgd', get_template_directory_uri() . '/assets/js/masonry.pkgd.min.js',  array('jquery'), null, true);
    wp_enqueue_script( 'isotopepkgd', get_template_directory_uri() . '/assets/js/isotope.pkgd.min.js',  array('jquery'), null, true);
    wp_enqueue_script( 'lightbox', get_template_directory_uri() . '/assets/js/lightbox.js',  array('jquery'), null, true);
    wp_enqueue_script( 'waypoints', get_template_directory_uri() . '/assets/js/waypoints.min.js',  array('jquery'), null, true);
    wp_enqueue_script( 'jquerycounterup', get_template_directory_uri() . '/assets/js/jquery.counterup.min.js',  array('jquery'), null, true);
    wp_enqueue_script( 'wow', get_template_directory_uri() . '/assets/js/wow.min.js',  array('jquery'), null, true);
    wp_enqueue_script( 'script', get_template_directory_uri() . '/assets/js/script.js',  array('jquery'), null, true);


    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }

	wp_enqueue_style( 'eltron-fonts', eltron_tt_g_fonts(), array(), null );

}

add_action( 'wp_enqueue_scripts', 'eltron_scripts' );

if ( ! function_exists( 'eltron_tt_g_fonts' ) ) {
	/**
	 * @return string Google fonts URL for the theme.
	 */
	function eltron_tt_g_fonts() {

		$fonts_url = '';
		$fonts     = array();
		$subsets   = 'latin,latin-ext';

		/* translators: If there are characters in your language that are not supported by Merriweather, translate this to 'off'. Do not translate into your own language. */
		if ( 'off' !== _x( 'on', 'Google font: on or off', 'eltron' ) ) {
			$fonts[] = 'Open Sans:300,400,400i,600,600i,700,800,900';
		}
		if ( $fonts ) {
			$fonts_url = add_query_arg( array(
				'family' => urlencode( implode( '|', $fonts ) ),
				'subset' => urlencode( $subsets ),
			), 'https://fonts.googleapis.com/css' );
		}

		return $fonts_url;
	}
}
