<?php
function eltron_import_files() {

  // Note: query import file path is set inside function.
  $eltron_local_import_path = trailingslashit( get_template_directory() ) . 'inc/theme-helpers/demo-import/';
  $eltron_local_import_url = trailingslashit( get_template_directory_uri() ) . 'inc/theme-helpers/demo-import/';
  $eltron_xml_file         = 'data.xml';
  $eltron_widget_file      = 'widgets.wie';
  $eltron_customizer_file  = 'settings.dat';
  $eltron_img_extn         = '.jpg'; /* Only need to edit if jpg is used. */

  $eltron_url        = 'https://eltron.bolvo.com/';  /* root of multisite install*/

  /* The demo folder name should be the slug, and screenshot should also be of same slug name in png. */
  /* Set homepage for each demo below. */
  $demo_folders = array (
					'demo2'             => 'Eltron Main Demo',
				  );

  $demos = array();
  foreach( $demo_folders as $demo_folder => $demoname ) {
	  $demos[] = array(
	      'import_file_name'             => $demoname,
	      'import_slug'                  => $demo_folder,
	      'categories'                   => array( esc_html__('Main','eltron') ),
	      'local_import_file'            => $eltron_local_import_path . trailingslashit( $demo_folder ) . $eltron_xml_file,
	      'local_import_widget_file'     => $eltron_local_import_path . trailingslashit( $demo_folder ) . $eltron_widget_file,
	      'local_import_customizer_file' => $eltron_local_import_path . trailingslashit( $demo_folder ) . $eltron_customizer_file,
	      'import_preview_image_url'     => $eltron_local_import_url . trailingslashit( $demo_folder ) . $demo_folder . $eltron_img_extn,
	      'import_notice'                => esc_html__( 'Please waiting for a few minutes, do not close the window or refresh the page until the data is imported.', 'eltron' ),
	      'preview_url'                  => $eltron_url . $demo_folder,
	  );
  }

	return $demos;

}
add_filter( 'pt-ocdi/import_files', 'eltron_import_files' );

function eltron_after_import_setup( $selected_import ) {
    function set_elementor_config() {
      add_option( 'elementor_disable_color_schemes', 'yes' ,'yes' );
      add_option( 'elementor_disable_typography_schemes', 'yes' ,'yes' );
    }
    function set_reading_options( $settings ) {
      $reading_settings = $settings['reading_settings'];
      if ( ! empty( $reading_settings ) ) {
        $homepage   = get_page_by_title( html_entity_decode( $reading_settings['homepage'] ) );
        $blog     = get_page_by_title( html_entity_decode( $reading_settings['blog'] ) );
        if ( ( isset( $homepage ) && $homepage->ID ) && ( isset( $blog ) && $blog->ID) ) {
            update_option( 'show_on_front',   'page' );
            update_option( 'page_on_front',   $homepage->ID );
            update_option( 'page_for_posts',  $blog->ID );
          return true;
        }
      }
      return false;
    }
    function set_woocommerce_pages( $settings ) {
      if ( class_exists( 'Woocommerce' ) && ! empty( $settings['woocommerce_pages'] ) ) {
        foreach ( $settings['woocommerce_pages'] as $woo_name => $woo_title ) {
          $woopage = get_page_by_title( $woo_title );
          if ( isset( $woopage ) && property_exists( $woopage, 'ID' ) ) {
            update_option( $woo_name, $woopage->ID );
          }
        }
        return true;
      }
      return false;
    }
    function set_nav_menus( $settings ) {

      if ( is_array( $settings['navigation'] ) ) {
        $locations = get_theme_mod( 'nav_menu_locations' );
        $menus = wp_get_nav_menus();

        foreach ( (array) $menus as $theme_menu ) {
          foreach ( (array) $settings['navigation'] as $import_menu ) {
            if ( $theme_menu->name == $import_menu['name'] ) {
              $locations[ $import_menu['location'] ] = $theme_menu->term_id;
            }
          }
        }

        set_theme_mod( 'nav_menu_locations', $locations );
        return true;
      }
      return false;
    }
    function eltron_get_demo_path() {
  		$upload_dir = wp_upload_dir();
  		$dir = path_join( $upload_dir['basedir'], 'demo_files' );

  		return $dir;
  	}
    function set_rev_sliders( $revsliders ) {

      if ( class_exists( 'RevSlider' ) && ! empty( $revsliders ) ) {
        $slider = new RevSlider();

        foreach( $revsliders as $filepath ) {
          $slider->importSliderFromPost(true,true,$filepath);
          @unlink( $filepath );
        }

        return true;
      }
      return false;
    }

    $json = null;
    $revsliders = array();
    $homepage = 'Home';

    if( 'demo1' === $selected_import['import_slug'] ) {
    }
    if( 'demo2' === $selected_import['import_slug'] ) {
      $homepage = 'Home';
    }

	function eltron_import_data( $file='', $addon_cat=false ) {

		require_once(ABSPATH . 'wp-admin/includes/file.php');

	    WP_Filesystem();
	    global $wp_filesystem;
	    global $wpdb;

	    if(!is_readable($file)) {
	        echo 'File not found or not readable '.$file;
	    }

		$query_ins = $wp_filesystem->get_contents( $file );

		// we need to add table name dynamically, so make sure its removed from sql file.
		global $wpdb;
		if( $addon_cat ) {

			$query_ins = "INSERT INTO ".$wpdb->prefix."addonlibrary_categories " . $query_ins;
		    $rows_affected = $wpdb->query( $query_ins );
			if( $rows_affected ) {
				update_option('blv_addons_cat_import', 'done');
			}

		} else {

			$query_ins = "INSERT INTO ".$wpdb->prefix."addonlibrary_addons " . $query_ins;
		    $rows_affected = $wpdb->query( $query_ins );
			if( $rows_affected ) {
				update_option('blv_addons_import', 'done');
			}

		}
	}

    function eltron_import_addons(){

	  $eltron_local_import_addon = trailingslashit( get_template_directory_uri() ) . 'inc/theme-helpers/demo-import/eltron-addons.txt';
	  $eltron_local_import_cat = trailingslashit( get_template_directory_uri() ) . 'inc/theme-helpers/demo-import/eltron-addons-cat.txt';
		if( class_exists( 'OCDI_Plugin' ) ) {
			$eltron_downloader         = new \OCDI\Downloader;
			$eltron_local_import_addon = $eltron_downloader->download_file( $eltron_local_import_addon, 'eltron-addons.txt' );
			$eltron_local_import_cat   = $eltron_downloader->download_file( $eltron_local_import_cat, 'eltron-addons-cat.txt' );
			if ( ! get_option( 'blv_addons_import' ) && ! is_object( $eltron_local_import_addon ) ) {
				eltron_import_data( $eltron_local_import_addon );
			}

			if ( ! get_option( 'blv_addons_cat_import' ) && ! is_object( $eltron_local_import_cat ) ) {
				eltron_import_data( $eltron_local_import_cat, true );
			}
		}
    }

	$settings = array (
      'reading_settings' =>
        array (
          'homepage' => $homepage,
          'blog' => 'Blog',
        ),
      'woocommerce_pages' =>
        array (
          'woocommerce_shop_page_id' => 'Shop',
          'woocommerce_cart_page_id' => 'Cart',
          'woocommerce_checkout_page_id' => 'Checkout',
          'woocommerce_myaccount_page_id' => 'My Account',
        ),
      'navigation' =>
        array (
          0 =>
          array (
            'name' => 'Primary Menu',
            'location' => 'header-menu-1',
          ),
          1 =>
          array (
            'name' => 'Primary Menu',
            'location' => 'header-mobile-menu',
          ),
        ),
    );
    set_elementor_config();
    set_reading_options( $settings );
    set_woocommerce_pages( $settings );
    set_nav_menus( $settings );
    eltron_import_addons( $settings );
    //set_rev_sliders( $revsliders );

    flush_rewrite_rules();
}
add_action( 'pt-ocdi/after_import', 'eltron_after_import_setup' );

add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );
