<?php
/**
 * Customizer settings: Header > Social Links
 *
 * @package Eltron
 **/

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$section = 'eltron_section_header_social';

/**
 * ====================================================
 * Social Links
 * ====================================================
 */

// Heading: Social Links
$wp_customize->add_control( new Eltron_Customize_Control_Heading( $wp_customize, 'heading_header_social', array(
	'section'     => $section,
	'settings'    => array(),
	'label'       => esc_html__( 'Social Links', 'eltron' ),
	'description' => sprintf(
		/* translators: %s: link to "Global Settings" section. */
		esc_html__( 'You can edit Social Media URLs via %s.', 'eltron' ),
		'<a href="' . esc_attr( add_query_arg( 'autofocus[panel]', 'eltron_panel_global_settings', remove_query_arg( 'autofocus' ) ) ) . '" class="eltron-customize-goto-control">' . esc_html__( 'Global Settings', 'eltron' ) . '</a>'
	),
	'priority'    => 10,
) ) );

// Social links
$key = 'header_social_links';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'transport'   => 'postMessage',
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'multiselect' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Builder( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Active links', 'eltron' ),
	'choices'     => eltron_get_social_media_types(),
	'priority'    => 10,
) ) );

// Selective Refresh
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial( $key, array(
		'selector'            => '.eltron-header-social',
		'container_inclusive' => true,
		'render_callback'     => 'eltron_header_element__social',
		'fallback_refresh'    => false,
	) );
}

// Social links target
$key = 'header_social_links_target';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'transport'   => 'postMessage',
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'select' ),
) );
$wp_customize->add_control( $key, array(
	'type'        => 'select',
	'section'     => $section,
	'label'       => esc_html__( 'Open links in', 'eltron' ),
	'choices'     => array(
		'self'  => esc_html__( 'Same tab', 'eltron' ),
		'blank' => esc_html__( 'New tab', 'eltron' ),
	),
	'priority'    => 10,
) );