<?php
/**
 * Customizer settings: General Styles > Border & Subtle Background
 *
 * @package Eltron
 **/

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$section = 'eltron_section_line_subtle';

// Line / border color
$key = 'border_color';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'transport'   => 'postMessage',
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'color' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Color( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Line / border color', 'eltron' ),
	'description' => esc_html__( 'Used on &lt;hr&gt; and default border color of all elements.', 'eltron' ),
	'priority'    => 10,
) ) );

// Subtle color
$key = 'subtle_color';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'transport'   => 'postMessage',
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'color' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Color( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Subtle background color', 'eltron' ),
	'description' => esc_html__( 'Used as background color of &lt;code&gt;, &lt;pre&gt;, tagclouds, and archive title. Usually slightly darker or lighter than the page background color.', 'eltron' ),
	'priority'    => 10,
) ) );
