<?php
/**
 * Customizer settings: Footer > Builder
 *
 * @package Eltron
 **/

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$section = 'eltron_section_footer_builder';

/**
 * ====================================================
 * Builder
 * ====================================================
 */

ob_start(); ?>
<span class="button button-secondary eltron-builder-hide eltron-builder-toggle"><span class="dashicons dashicons-no"></span><?php esc_html_e( 'Hide', 'eltron' ); ?></span>
<span class="button button-primary eltron-builder-show eltron-builder-toggle"><span class="dashicons dashicons-edit"></span><?php esc_html_e( 'Footer Builder', 'eltron' ); ?></span>
<?php $switcher = ob_get_clean();

// --- Blank: Footer Builder Switcher
$wp_customize->add_control( new Eltron_Customize_Control_Blank( $wp_customize, 'footer_builder_actions', array(
	'section'     => $section,
	'settings'    => array(),
	'description' => $switcher,
	'priority'    => 10,
) ) );

// Widgets columns
$key = 'footer_widgets_bar';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'select' ),
) );
$wp_customize->add_control( $key, array(
	'type'        => 'select',
	'section'     => $section,
	'label'       => esc_html__( 'Widgets columns', 'eltron' ),
	'choices'     => array(
		0 => esc_html__( '-- Disabled --', 'eltron' ),
		1 => esc_html__( '1 column', 'eltron' ),
		2 => esc_html__( '2 columns', 'eltron' ),
		3 => esc_html__( '3 columns', 'eltron' ),
		4 => esc_html__( '4 columns', 'eltron' ),
		5 => esc_html__( '5 columns', 'eltron' ),
		6 => esc_html__( '6 columns', 'eltron' ),
	),
	'priority'    => 10,
) );

// ------
$wp_customize->add_control( new Eltron_Customize_Control_HR( $wp_customize, 'hr_footer_builder', array(
	'section'     => $section,
	'settings'    => array(),
	'priority'    => 20,
) ) );

// Bottom bar elements
$key = 'footer_elements';
$settings = array(
	'bottom_left'   => $key . '_bottom_left',
	'bottom_center' => $key . '_bottom_center',
	'bottom_right'  => $key . '_bottom_right',
);
foreach ( $settings as $setting ) {
	$wp_customize->add_setting( $setting, array(
		'default'     => eltron_array_value( $defaults, $setting ),
		'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'builder' ),
	) );
}
$wp_customize->add_control( new Eltron_Customize_Control_Builder( $wp_customize, $key, array(
	'settings'    => $settings,
	'section'     => $section,
	'label'       => esc_html__( 'Bottom bar elements', 'eltron' ),
	'choices'     => array(
		'copyright' => '<span class="dashicons dashicons-editor-code"></span>' . esc_html__( 'Copyright', 'eltron' ),
		/* translators: %s: instance number. */
		'menu-1'    => '<span class="dashicons dashicons-admin-links"></span>' . sprintf( esc_html__( 'Footer Menu %s', 'eltron' ), 1 ),
		'social'    => '<span class="dashicons dashicons-twitter"></span>' . esc_html__( 'Social', 'eltron' ),
	),
	'labels'     => array(
		'bottom_left'   => is_rtl() ? esc_html__( 'Right', 'eltron' ) : esc_html__( 'Left', 'eltron' ),
		'bottom_center' => esc_html__( 'Center', 'eltron' ),
		'bottom_right'  => is_rtl() ? esc_html__( 'Left', 'eltron' ) : esc_html__( 'Right', 'eltron' ),
	),
	'limitations' => array(),
	'priority'    => 20,
) ) );