<?php
/**
 * Customizer settings: Blog > Post Layout: Grid
 *
 * @package Eltron
 **/

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$section = 'eltron_section_entry_grid';

/**
 * ====================================================
 * Layout
 * ====================================================
 */

// Grid columns
$key = 'blog_index_grid_columns';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'transport'   => 'postMessage',
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'dimension' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Slider( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Columns', 'eltron' ),
	'units'       => array(
		'' => array(
			'min'  => 2,
			'max'  => 4,
			'step' => 1,
			'label' => 'col',
		),
	),
	'priority'    => 10,
) ) );

// Rows gutter
$key = 'blog_index_grid_rows_gutter';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'transport'   => 'postMessage',
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'dimension' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Slider( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Rows gutter', 'eltron' ),
	'units'       => array(
		'px' => array(
			'min'  => 0,
			'max'  => 40,
			'step' => 1,
		),
		'em' => array(
			'min'  => 0,
			'max'  => 3,
			'step' => 0.05,
		),
	),
	'priority'    => 10,
) ) );

// Columns gutter
$key = 'blog_index_grid_columns_gutter';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'transport'   => 'postMessage',
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'dimension' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Slider( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Columns gutter', 'eltron' ),
	'units'       => array(
		'px' => array(
			'min'  => 0,
			'max'  => 40,
			'step' => 1,
		),
		'em' => array(
			'min'  => 0,
			'max'  => 3,
			'step' => 0.05,
		),
	),
	'priority'    => 10,
) ) );

/**
 * ====================================================
 * Item
 * ====================================================
 */

// Heading: Item
$wp_customize->add_control( new Eltron_Customize_Control_Heading( $wp_customize, 'heading_entry_grid_item', array(
	'section'     => $section,
	'settings'    => array(),
	'label'       => esc_html__( 'Item', 'eltron' ),
	'priority'    => 20,
) ) );

// Padding
$key = 'entry_grid_padding';
$settings = array(
	$key,
	$key . '__tablet',
	$key . '__mobile',
);
foreach ( $settings as $setting ) {
	$wp_customize->add_setting( $setting, array(
		'default'     => eltron_array_value( $defaults, $setting ),
		'transport'   => 'postMessage',
		'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'dimensions' ),
	) );
}
$wp_customize->add_control( new Eltron_Customize_Control_Dimensions( $wp_customize, $key, array(
	'settings'    => $settings,
	'section'     => $section,
	'label'       => esc_html__( 'Padding', 'eltron' ),
	'units'       => array(
		'px' => array(
			'min'  => 0,
			'step' => 1,
		),
		'em' => array(
			'min'  => 0,
			'step' => 0.05,
		),
	),
	'priority'    => 20,
) ) );

// Border
$key = 'entry_grid_border';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'transport'   => 'postMessage',
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'dimensions' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Dimensions( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Border', 'eltron' ),
	'units'       => array(
		'px' => array(
			'min'  => 0,
			'step' => 1,
		),
	),
	'priority'    => 20,
) ) );

// Make items in a row to be in same height
$key = 'entry_grid_same_height';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'toggle' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Toggle( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Same height items in a row', 'eltron' ),
	'priority'    => 20,
) ) );

/**
 * ====================================================
 * Featured Media
 * ====================================================
 */

// Heading: Featured Media
$wp_customize->add_control( new Eltron_Customize_Control_Heading( $wp_customize, 'heading_entry_grid_featured_media', array(
	'section'     => $section,
	'settings'    => array(),
	'label'       => esc_html__( 'Featured Media', 'eltron' ),
	'priority'    => 30,
) ) );

// Featured media position
$key = 'entry_grid_featured_media_position';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'select' ),
) );
$wp_customize->add_control( $key, array(
	'type'        => 'select',
	'section'     => $section,
	'label'       => esc_html__( 'Featured media position', 'eltron' ),
	'choices'     => array(
		'before-entry-header' => esc_html__( 'Before Post Header', 'eltron' ),
		'after-entry-header'  => esc_html__( 'After Post Header', 'eltron' ),
		'disabled'            => esc_html__( 'Disabled', 'eltron' ),
	),
	'priority'    => 30,
) );

// Ignore padding
$key = 'entry_grid_featured_media_ignore_padding';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'toggle' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Toggle( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Ignore padding', 'eltron' ),
	'priority'    => 30,
) ) );

/**
 * ====================================================
 * Post Header
 * ====================================================
 */

// Heading: Post Header
$wp_customize->add_control( new Eltron_Customize_Control_Heading( $wp_customize, 'heading_entry_grid_header', array(
	'section'     => $section,
	'settings'    => array(),
	'label'       => esc_html__( 'Post Header', 'eltron' ),
	'priority'    => 40,
) ) );

// Elements to display
$key = 'entry_grid_header';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'multiselect' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Builder( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Elements to display', 'eltron' ),
	'choices'     => array(
		'header-meta' => esc_html__( 'Header Meta', 'eltron' ),
		'title'       => esc_html__( 'Title', 'eltron' ),
	),
	'layout'      => 'block',
	'priority'    => 40,
) ) );

// Alignment
$key = 'entry_grid_header_alignment';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'transport'   => 'postMessage',
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'select' ),
) );
$wp_customize->add_control( $key, array(
	'type'        => 'select',
	'section'     => $section,
	'label'       => esc_html__( 'Alignment', 'eltron' ),
	'choices'     => array(
		'left'   => is_rtl() ? esc_html__( 'Right', 'eltron' ) : esc_html__( 'Left', 'eltron' ),
		'center' => esc_html__( 'Center', 'eltron' ),
		'right'  => is_rtl() ? esc_html__( 'Left', 'eltron' ) : esc_html__( 'Right', 'eltron' ),
	),
	'priority'    => 40,
) );

// Header meta text
$key = 'entry_grid_header_meta';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'text' ),
) );
$wp_customize->add_control( $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Header meta text', 'eltron' ),
	'description' => esc_html__( 'Available tags: {{date}}, {{categories}}, {{tags}}, {{author}}, {{avatar}}, {{comments}}.', 'eltron' ),
	'priority'    => 40,
) );

/**
 * ====================================================
 * Content
 * ====================================================
 */

// Heading: Content
$wp_customize->add_control( new Eltron_Customize_Control_Heading( $wp_customize, 'heading_entry_grid_content', array(
	'section'     => $section,
	'settings'    => array(),
	'label'       => esc_html__( 'Content', 'eltron' ),
	'priority'    => 50,
) ) );

// Entry grid excerpt length
$key = 'entry_grid_excerpt_length';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'dimension' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Slider( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Excerpt words limit', 'eltron' ),
	'description' => esc_html__( 'Fill with 0 to disable excerpt.', 'eltron' ),
	'units'       => array(
		'' => array(
			'min'  => 0,
			'max'  => 200,
			'step' => 1,
			'label' => 'wrd',
		),
	),
	'priority'    => 50,
) ) );

// Read more
$key = 'entry_grid_read_more_display';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'select' ),
) );
$wp_customize->add_control( $key, array(
	'type'        => 'select',
	'section'     => $section,
	'label'       => esc_html__( 'Read more', 'eltron' ),
	'choices'     => array(
		''       => esc_html__( 'None', 'eltron' ),
		'text'   => esc_html__( 'Text', 'eltron' ),
		'button' => esc_html__( 'Button', 'eltron' ),
	),
	'priority'    => 50,
) );

// Read more text
$key = 'entry_grid_read_more_text';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'text' ),
) );
$wp_customize->add_control( $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Read more text', 'eltron' ),
	'input_attrs' => array(
		'placeholder' => esc_html__( 'Read more', 'eltron' ),
	),
	'priority'    => 50,
) );

/**
 * ====================================================
 * Post Footer
 * ====================================================
 */

// Heading: Post Footer
$wp_customize->add_control( new Eltron_Customize_Control_Heading( $wp_customize, 'heading_entry_grid_meta', array(
	'section'     => $section,
	'settings'    => array(),
	'label'       => esc_html__( 'Post Footer', 'eltron' ),
	'priority'    => 60,
) ) );

// Elements to display
$key = 'entry_grid_footer';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'multiselect' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Builder( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Elements to display', 'eltron' ),
	'choices'     => array(
		'footer-meta' => esc_html__( 'Footer Meta', 'eltron' ),
	),
	'layout'      => 'block',
	'priority'    => 60,
) ) );

// Alignment
$key = 'entry_grid_footer_alignment';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'transport'   => 'postMessage',
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'select' ),
) );
$wp_customize->add_control( $key, array(
	'type'        => 'select',
	'section'     => $section,
	'label'       => esc_html__( 'Alignment', 'eltron' ),
	'choices'     => array(
		'left'   => is_rtl() ? esc_html__( 'Right', 'eltron' ) : esc_html__( 'Left', 'eltron' ),
		'center' => esc_html__( 'Center', 'eltron' ),
		'right'  => is_rtl() ? esc_html__( 'Left', 'eltron' ) : esc_html__( 'Right', 'eltron' ),
	),
	'priority'    => 60,
) );

// Footer meta text
$key = 'entry_grid_footer_meta';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'text' ),
) );
$wp_customize->add_control( $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Footer meta text', 'eltron' ),
	'description' => esc_html__( 'Available tags: {{date}}, {{categories}}, {{tags}}, {{author}}, {{avatar}}, {{comments}}', 'eltron' ),
	'priority'    => 60,
) );

/**
 * ====================================================
 * Colors
 * ====================================================
 */

// Heading: Colors
$wp_customize->add_control( new Eltron_Customize_Control_Heading( $wp_customize, 'heading_entry_grid_colors', array(
	'section'     => $section,
	'settings'    => array(),
	'label'       => esc_html__( 'Colors', 'eltron' ),
	'priority'    => 80,
) ) );

// Colors
$colors = array(
	'entry_grid_bg_color'     => esc_html__( 'Background color', 'eltron' ),
	'entry_grid_border_color' => esc_html__( 'Border color', 'eltron' ),
);
foreach ( $colors as $key => $label ) {
	$wp_customize->add_setting( $key, array(
		'default'     => eltron_array_value( $defaults, $key ),
		'transport'   => 'postMessage',
		'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'color' ),
	) );
	$wp_customize->add_control( new Eltron_Customize_Control_Color( $wp_customize, $key, array(
		'section'     => $section,
		'label'       => $label,
		'priority'    => 80,
	) ) );
}