<?php

/**
 * Customizer sections
 *
 * @package Eltron
 **/
// Prevent direct access.
if ( !defined( 'ABSPATH' ) ) {
    exit;
}
// Global Settings
$panel = 'eltron_panel_global_settings';
$wp_customize->add_panel( $panel, array(
    'title'    => esc_html__( 'Global Settings', 'eltron' ),
    'priority' => 1,
) );
// Site Identity
$wp_customize->get_section( 'title_tagline' )->panel = $panel;
$wp_customize->get_section( 'title_tagline' )->priority = 10;
// Homepage Settings
$wp_customize->get_section( 'static_front_page' )->panel = $panel;
$wp_customize->get_section( 'static_front_page' )->priority = 10;
// ------
$wp_customize->add_section( new Eltron_Customize_Section_Spacer( $wp_customize, 'eltron_section_spacer_global_settings', array(
    'panel'    => $panel,
    'priority' => 20,
) ) );
// Color Palette
$wp_customize->add_section( 'eltron_section_color_palette', array(
    'title'       => esc_html__( 'Color Palette', 'eltron' ),
    'description' => '<p>' . esc_html__( 'Color palette makes it easier and faster to choose colors while designing your website.', 'eltron' ) . '</p>',
    'panel'       => $panel,
    'priority'    => 20,
) );
// Google Fonts
$wp_customize->add_section( 'eltron_section_google_fonts', array(
    'title'    => esc_html__( 'Google Fonts', 'eltron' ),
    'panel'    => $panel,
    'priority' => 20,
) );
// Social
$wp_customize->add_section( 'eltron_section_social', array(
    'title'       => esc_html__( 'Social Media Links', 'eltron' ),
    'description' => '<p>' . esc_html__( 'Please use full URL format with http:// or https://', 'eltron' ) . '</p>',
    'panel'       => $panel,
    'priority'    => 20,
) );
// ------
$wp_customize->add_section( new Eltron_Customize_Section_Spacer( $wp_customize, 'eltron_section_spacer_170', array(
    'priority' => 170,
) ) );
// General Styles
$panel = 'eltron_panel_general_styles';
$wp_customize->add_panel( $panel, array(
    'title'    => esc_html__( 'General Styles', 'eltron' ),
    'priority' => 171,
) );
// Body (Base)
$wp_customize->add_section( 'eltron_section_base', array(
    'title'       => esc_html__( 'Body (Base)', 'eltron' ),
    'description' => '<p>' . esc_html__( 'The global settings of body typography and colors.', 'eltron' ) . '</p>',
    'panel'       => $panel,
    'priority'    => 10,
) );
// Border & Subtle Background
$wp_customize->add_section( 'eltron_section_line_subtle', array(
    'title'    => esc_html__( 'Border & Subtle Background', 'eltron' ),
    'panel'    => $panel,
    'priority' => 10,
) );
// Link
$wp_customize->add_section( 'eltron_section_link', array(
    'title'    => esc_html__( 'Link', 'eltron' ),
    'panel'    => $panel,
    'priority' => 10,
) );
// Headings (H1 - H4)
$wp_customize->add_section( 'eltron_section_headings', array(
    'title'       => esc_html__( 'Headings (H1 - H4)', 'eltron' ),
    'description' => '<p>' . esc_html__( 'Used on all H1 - H4 tags globally.', 'eltron' ) . '</p>',
    'panel'       => $panel,
    'priority'    => 10,
) );
// Blockquote
$wp_customize->add_section( 'eltron_section_blockquote', array(
    'title'    => esc_html__( 'Blockquote', 'eltron' ),
    'panel'    => $panel,
    'priority' => 10,
) );
// Form Input
$wp_customize->add_section( 'eltron_section_form_input', array(
    'title'    => esc_html__( 'Form Input', 'eltron' ),
    'panel'    => $panel,
    'priority' => 10,
) );
// Button
$wp_customize->add_section( 'eltron_section_button', array(
    'title'    => esc_html__( 'Button', 'eltron' ),
    'panel'    => $panel,
    'priority' => 10,
) );
// Title
$wp_customize->add_section( 'eltron_section_title', array(
    'title'       => esc_html__( 'Title', 'eltron' ),
    'description' => '<p>' . esc_html__( 'Used on Default Post title and Static Page title. By default, it uses H1 styles.', 'eltron' ) . '</p>',
    'panel'       => $panel,
    'priority'    => 10,
) );
// Small Title
$wp_customize->add_section( 'eltron_section_small_title', array(
    'title'       => esc_html__( 'Small Title', 'eltron' ),
    'description' => '<p>' . esc_html__( 'Used on Grid Post title, and other subsidiary headings like "Leave a Reply", "2 Comments", etc. By default, it uses H3 styles.', 'eltron' ) . '</p>',
    'panel'       => $panel,
    'priority'    => 10,
) );
// Meta Info
$wp_customize->add_section( 'eltron_section_meta', array(
    'title'       => esc_html__( 'Meta Info', 'eltron' ),
    'description' => '<p>' . esc_html__( 'Used on Post meta, Widget meta, Comments meta, and other small info text.', 'eltron' ) . '</p>',
    'panel'       => $panel,
    'priority'    => 10,
) );
// Page Canvas & Wrapper
$wp_customize->add_section( 'eltron_section_page_container', array(
    'title'    => esc_html__( 'Page Canvas & Wrapper', 'eltron' ),
    'priority' => 172,
) );
// Header
$panel = 'eltron_panel_header';
$switcher = '
<div class="eltron-responsive-switcher nav-tab-wrapper wp-clearfix">
	<a href="#" class="nav-tab preview-desktop eltron-responsive-switcher-button" data-device="desktop">
		<span class="dashicons dashicons-desktop"></span>
		<span>' . esc_html__( 'Desktop', 'eltron' ) . '</span>
	</a>
	<a href="#" class="nav-tab preview-tablet preview-mobile eltron-responsive-switcher-button" data-device="tablet">
		<span class="dashicons dashicons-smartphone"></span>
		<span>' . esc_html__( 'Tablet / Mobile', 'eltron' ) . '</span>
	</a>
</div>
';
$wp_customize->add_panel( $panel, array(
    'title'       => esc_html__( 'Header', 'eltron' ),
    'description' => $switcher,
    'priority'    => 173,
) );
// Header Builder
$wp_customize->add_section( 'eltron_section_header_builder', array(
    'title'    => esc_html__( 'Header Builder', 'eltron' ),
    'panel'    => $panel,
    'priority' => 10,
) );
// ------
$wp_customize->add_section( new Eltron_Customize_Section_Spacer( $wp_customize, 'eltron_section_spacer_header_bars', array(
    'panel'    => $panel,
    'priority' => 10,
) ) );
// Top Bar
$wp_customize->add_section( 'eltron_section_header_top_bar', array(
    'title'    => esc_html__( 'Top Bar', 'eltron' ),
    'panel'    => $panel,
    'priority' => 10,
) );
// Main Bar
$wp_customize->add_section( 'eltron_section_header_main_bar', array(
    'title'    => esc_html__( 'Main Bar', 'eltron' ),
    'panel'    => $panel,
    'priority' => 10,
) );
// Bottom Bar
$wp_customize->add_section( 'eltron_section_header_bottom_bar', array(
    'title'    => esc_html__( 'Bottom Bar', 'eltron' ),
    'panel'    => $panel,
    'priority' => 10,
) );
// ------
$wp_customize->add_section( new Eltron_Customize_Section_Spacer( $wp_customize, 'eltron_section_spacer_header_mobile_bars', array(
    'panel'    => $panel,
    'priority' => 20,
) ) );
// Mobile Main Bar
$wp_customize->add_section( 'eltron_section_header_mobile_main_bar', array(
    'title'    => esc_html__( 'Mobile Main Bar', 'eltron' ),
    'panel'    => $panel,
    'priority' => 20,
) );
// Mobile Drawer
$wp_customize->add_section( 'eltron_section_header_mobile_vertical_bar', array(
    'title'    => esc_html__( 'Mobile Drawer (Popup)', 'eltron' ),
    'panel'    => $panel,
    'priority' => 20,
) );
// ------
$wp_customize->add_section( new Eltron_Customize_Section_Spacer( $wp_customize, 'eltron_section_spacer_header_elements', array(
    'panel'    => $panel,
    'priority' => 40,
) ) );
// Logo
$wp_customize->add_section( 'eltron_section_header_logo', array(
    'title'    => esc_html__( 'Element: Logo', 'eltron' ),
    'panel'    => $panel,
    'priority' => 40,
) );
// Search
$wp_customize->add_section( 'eltron_section_header_search', array(
    'title'    => esc_html__( 'Element: Search', 'eltron' ),
    'panel'    => $panel,
    'priority' => 40,
) );
// HTML
$wp_customize->add_section( 'eltron_section_header_html', array(
    'title'    => esc_html__( 'Element: HTML(s)', 'eltron' ),
    'panel'    => $panel,
    'priority' => 40,
) );
// Social
$wp_customize->add_section( 'eltron_section_header_cart', array(
    'title'    => esc_html__( 'Element: Shopping Cart', 'eltron' ),
    'panel'    => $panel,
    'priority' => 40,
) );
// Social
$wp_customize->add_section( 'eltron_section_header_social', array(
    'title'    => esc_html__( 'Element: Social', 'eltron' ),
    'panel'    => $panel,
    'priority' => 40,
) );
// ------
$wp_customize->add_section( new Eltron_Customize_Section_Spacer( $wp_customize, 'eltron_section_spacer_header_plus', array(
    'panel'    => $panel,
    'priority' => 50,
) ) );
// Page Header
$wp_customize->add_section( 'eltron_section_page_header', array(
    'title'       => esc_html__( 'Page Header', 'eltron' ),
    'description' => esc_html__( 'Page Header is a section located between Header and Content section and used to display the title of current page.', 'eltron' ),
    'priority'    => 174,
) );
// Content & Sidebar
$panel = 'eltron_panel_content';
$wp_customize->add_panel( $panel, array(
    'title'    => esc_html__( 'Content & Sidebar', 'eltron' ),
    'priority' => 175,
) );
// Content Section
$wp_customize->add_section( 'eltron_section_content', array(
    'title'    => esc_html__( 'Content Section', 'eltron' ),
    'panel'    => $panel,
    'priority' => 10,
) );
// ------
$wp_customize->add_section( new Eltron_Customize_Section_Spacer( $wp_customize, 'eltron_section_spacer_content', array(
    'panel'    => $panel,
    'priority' => 10,
) ) );
// Main Content Area
$wp_customize->add_section( 'eltron_section_main', array(
    'title'    => esc_html__( 'Main Content Area', 'eltron' ),
    'panel'    => $panel,
    'priority' => 10,
) );
// Sidebar Area
$wp_customize->add_section( 'eltron_section_sidebar', array(
    'title'    => esc_html__( 'Sidebar Area', 'eltron' ),
    'panel'    => $panel,
    'priority' => 10,
) );
// Footer
$panel = 'eltron_panel_footer';
$wp_customize->add_panel( $panel, array(
    'title'    => esc_html__( 'Footer', 'eltron' ),
    'priority' => 176,
) );
// Footer Builder
$wp_customize->add_section( 'eltron_section_footer_builder', array(
    'title'    => esc_html__( 'Footer Builder', 'eltron' ),
    'panel'    => $panel,
    'priority' => 10,
) );
// ------
$wp_customize->add_section( new Eltron_Customize_Section_Spacer( $wp_customize, 'eltron_section_spacer_footer_bars', array(
    'panel'    => $panel,
    'priority' => 10,
) ) );
// Widgets Bar
$wp_customize->add_section( 'eltron_section_footer_widgets_bar', array(
    'title'    => esc_html__( 'Widgets Bar', 'eltron' ),
    'panel'    => $panel,
    'priority' => 20,
) );
// Bottom Bar
$wp_customize->add_section( 'eltron_section_footer_bottom_bar', array(
    'title'    => esc_html__( 'Bottom Bar', 'eltron' ),
    'panel'    => $panel,
    'priority' => 20,
) );
// ------
$wp_customize->add_section( new Eltron_Customize_Section_Spacer( $wp_customize, 'eltron_section_spacer_footer_elements', array(
    'panel'    => $panel,
    'priority' => 30,
) ) );
// Copyright
$wp_customize->add_section( 'eltron_section_footer_copyright', array(
    'title'    => esc_html__( 'Element: Copyright', 'eltron' ),
    'panel'    => $panel,
    'priority' => 30,
) );
// Social
$wp_customize->add_section( 'eltron_section_footer_social', array(
    'title'    => esc_html__( 'Element: Social', 'eltron' ),
    'panel'    => $panel,
    'priority' => 30,
) );
// ------
$wp_customize->add_section( new Eltron_Customize_Section_Spacer( $wp_customize, 'eltron_section_spacer_scroll_to_top', array(
    'panel'    => $panel,
    'priority' => 40,
) ) );
// Scroll To Top
$wp_customize->add_section( 'eltron_section_scroll_to_top', array(
    'title'    => esc_html__( 'Scroll To Top', 'eltron' ),
    'panel'    => $panel,
    'priority' => 40,
) );
// ------
$wp_customize->add_section( new Eltron_Customize_Section_Spacer( $wp_customize, 'eltron_section_spacer_180', array(
    'priority' => 180,
) ) );
// Blog
$panel = 'eltron_panel_blog';
$wp_customize->add_panel( $panel, array(
    'title'    => esc_html__( 'Blog', 'eltron' ),
    'priority' => 181,
) );
// Post Index
$wp_customize->add_section( 'eltron_section_blog_index', array(
    'title'    => esc_html__( 'Posts Page', 'eltron' ),
    'panel'    => $panel,
    'priority' => 10,
) );
// Post Layout: Default
$wp_customize->add_section( 'eltron_section_entry_default', array(
    'title'    => esc_html__( 'Post Layout: Default', 'eltron' ),
    'panel'    => $panel,
    'priority' => 10,
) );
// Post Layout: Grid
$wp_customize->add_section( 'eltron_section_entry_grid', array(
    'title'    => esc_html__( 'Post Layout: Grid', 'eltron' ),
    'panel'    => $panel,
    'priority' => 10,
) );
// Single Post
$wp_customize->add_section( 'eltron_section_blog_single', array(
    'title'    => esc_html__( 'Single Post Page', 'eltron' ),
    'panel'    => $panel,
    'priority' => 20,
) );
// ------
$wp_customize->add_section( new Eltron_Customize_Section_Spacer( $wp_customize, 'eltron_section_spacer_blog_plus', array(
    'panel'    => $panel,
    'priority' => 30,
) ) );
// ------
$wp_customize->add_section( new Eltron_Customize_Section_Spacer( $wp_customize, 'eltron_section_spacer_190', array(
    'priority' => 190,
) ) );
// Dynamic Page Settings
$panel = 'eltron_panel_page_settings';
$wp_customize->add_panel( $panel, array(
    'title'       => esc_html__( 'Dynamic Page Settings', 'eltron' ),
    'description' => '<p>' . esc_html__( 'You can set different layout settings (like Header, Page Header, Content, Sidebar, and Footer) on each different page type.', 'eltron' ) . '</p>',
    'priority'    => 191,
) );
// Begin registering sections.
$i = 10;
foreach ( Eltron_Customizer::instance()->get_all_page_settings_types() as $ps_type => $ps_data ) {
    if ( 0 < strpos( $ps_type, '_archive' ) ) {
        $wp_customize->add_section( new Eltron_Customize_Section_Spacer( $wp_customize, 'eltron_section_spacer_page_settings_' . $i, array(
            'panel'    => $panel,
            'priority' => $i,
        ) ) );
    }
    $desc = eltron_array_value( $ps_data, 'description' );
    $wp_customize->add_section( 'eltron_section_page_settings_' . $ps_type, array(
        'title'       => eltron_array_value( $ps_data, 'title' ),
        'description' => ( !empty($desc) ? '<p>' . $desc . '</p>' : '' ),
        'panel'       => $panel,
        'priority'    => $i,
    ) );
    $i += 10;
}