<?php
/**
 * Plugin compatibility: Eltron Pro
 *
 * @package Eltron
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

class Eltron_Compatibility_Eltron_Pro {

	/**
	 * Singleton instance
	 *
	 * @var Eltron_Compatibility_Eltron_Pro
	 */
	private static $instance;

	/**
	 * ====================================================
	 * Singleton & constructor functions
	 * ====================================================
	 */

	/**
	 * Get singleton instance.
	 *
	 * @return Eltron_Compatibility_Eltron_Pro
	 */
	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
	 * Class constructor
	 */
	protected function __construct() {
		/**
		 * Compatibility for Eltron Pro prior to v1.1.0.
		 */

		// Get the main version without suffix like "dev", "alpha", "beta".
		if ( defined( 'ELTRON_PRO_VERSION' ) && version_compare( preg_replace( '/\-.*/', '', ELTRON_PRO_VERSION ), '1.1.0', '<' ) ) {

			// Add fallback compatibility for all Eltron Pro modules dynamic CSS.
			// Since Eltron v1.1.0, all dynamic CSS are printed using 'wp_add_inline_style' instead of manual printing on 'wp_head'.
			add_filter( 'eltron/frontend/inline_css', array( $this, 'fallback_compatibility_for_customizer_inline_css' ) );
		}
	}
	
	/**
	 * ====================================================
	 * Hook functions
	 * ====================================================
	 */

	/**
	 * Add fallback compatibility for all Eltron Pro modules dynamic CSS.
	 *
	 * @param string $css
	 * @return string
	 */
	public function fallback_compatibility_for_customizer_inline_css( $css ) {
		$postmessages = array();
		$active_modules = get_option( 'eltron_pro_active_modules', array() );

		foreach ( $active_modules as $i => $module_slug ) {

			$postmessages_file = ELTRON_PRO_DIR . 'inc/modules/' . $module_slug . '/customizer/postmessages.php';

			if ( file_exists( $postmessages_file ) ) {
				include( $postmessages_file );
			}
		}

		$generated_css = Eltron_Customizer::instance()->convert_postmessages_to_css_string( $postmessages );

		if ( ! empty( $generated_css ) ) {
			$css = "\n/* Eltron Pro Dynamic CSS (fallback compatibility prior Eltron Pro v1.1.0) */\n" . $generated_css;
		}

		return $css;
	}
}

Eltron_Compatibility_Eltron_Pro::instance();