<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Eltron
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

				/**
				 * Content - closing tag
				 */
				if ( apply_filters( 'eltron/frontend/show_content_wrapper', true ) ) {
					eltron_content_close();
				}

				/**
				 * Hook: eltron/frontend/before_footer
				 */
				do_action( 'eltron/frontend/before_footer' );

				/**
				 * Footer
				 */
				?>
				<footer id="colophon" class="site-footer eltron-footer" role="contentinfo" itemtype="https://schema.org/WPFooter" itemscope>
					<?php
					/**
					 * Hook: eltron/frontend/footer
					 *
					 * @hooked eltron_main_footer - 10
					 */
					do_action( 'eltron/frontend/footer' );
					?>
				</footer>
				<?php
				
				/**
				 * Hook: eltron/frontend/after_footer
				 */
				do_action( 'eltron/frontend/after_footer' );
				?>
				
			</div>
		</div>

		<?php
		/**
		 * Hook: eltron/frontend/after_canvas
		 */
		do_action( 'eltron/frontend/after_canvas' );
		
		/**
		 * Hook: wp_footer
		 */
		wp_footer();

		?>
	</body>
</html>