<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package Eltron
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Header
 */
get_header();

/**
 * Primary - opening tag
 */
eltron_primary_open();

/**
 * Hook: eltron/frontend/before_main
 */
do_action( 'eltron/frontend/before_main' );

?>
<section class="error-404 not-found">
	<div class="page-content">
		<h1><?php esc_html_e( 'Page Not Found', 'eltron' ); ?></h1>
		<p><?php esc_html_e( 'It looks like nothing was found at this location. Maybe try searching?', 'eltron' ); ?></p>
		<?php get_search_form(); ?>
	</div>
</section>
<?php

/**
 * Hook: eltron/frontend/after_main
 */
do_action( 'eltron/frontend/after_main' );

/**
 * Primary - closing tag
 */
eltron_primary_close();

/**
 * Sidebar
 */
get_sidebar();

/**
 * Footer
 */
get_footer();