<?php
/**
 * Blog Related Posts template.
 *
 * @package Eltron
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$thumbnail_display = eltron_get_theme_mod( 'blog_related_posts_thumbnail_display' );
$meta_display = eltron_get_theme_mod( 'blog_related_posts_meta_display' );
$columns = eltron_get_theme_mod( 'blog_related_posts_columns' );
?>
<div class="eltron-related-posts">
	<?php if ( '' !== $heading = trim( eltron_get_theme_mod( 'blog_related_posts_heading_text' ) ) ) : ?>
		<h2 class="eltron-related-posts-heading small-title"><?php echo $heading; // WPCS: XSS OK ?></h2>
	<?php endif; ?>
	<ul class="eltron-related-posts-list <?php echo esc_attr( 'eltron-related-posts-thumbnail-display-' . $thumbnail_display ); ?> <?php echo esc_attr( 'eltron-related-posts-columns-' . $columns ); ?>">
		<?php while ( have_posts() ) : the_post(); ?>
			<li class="eltron-related-post">
				<?php if ( '' !== $thumbnail_display && has_post_thumbnail() ) : ?>
					<a href="<?php the_permalink(); ?>" class="eltron-related-post-thumbnail">
						<?php echo get_the_post_thumbnail( null, eltron_get_theme_mod( 'blog_related_posts_thumbnail_size' ) ); ?>
					</a>
				<?php endif; ?>
				<div class="eltron-related-post-text">
					<h3 class="eltron-related-post-title">
						<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
					</h3>
					<?php if ( '' !== $meta_display ) : ?>
						<div class="eltron-related-post-meta entry-meta">
							<?php switch ( $meta_display ) {
								case 'date':
									echo esc_html( get_the_date( '') );
									break;
								
								case 'categories':
									$cat_objects = get_the_category();
									$cat_names = wp_list_pluck( $cat_objects, 'name' );

									echo esc_html( implode( esc_html_x( ', ', 'terms list separator', 'eltron-features' ), $cat_names ) );
									break;
							}
							?>
						</div>
					<?php endif; ?>
				</div>
			</li>
		<?php endwhile; ?>
	</ul>
</div>