<?php
/**
 * Customizer settings: WooCommerce > Products Grid
 *
 * @package Eltron Pro
 **/

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$section = 'woocommerce_products_grid';

/**
 * ====================================================
 * Grid Item
 * ====================================================
 */

// Padding
$key = 'woocommerce_products_grid_item_padding';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'transport'   => 'postMessage',
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'dimensions' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Dimensions( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Padding', 'eltron-features' ),
	'units'       => array(
		'px' => array(
			'min'  => 0,
			'step' => 1,
		),
		'em' => array(
			'min'  => 0,
			'step' => 0.05,
		),
	),
	'priority'    => 20,
) ) );

// Border
$key = 'woocommerce_products_grid_item_border';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'transport'   => 'postMessage',
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'dimensions' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Dimensions( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Border', 'eltron-features' ),
	'units'       => array(
		'px' => array(
			'min'  => 0,
			'step' => 1,
		),
	),
	'priority'    => 20,
) ) );

// Background color
$key = 'woocommerce_products_grid_item_bg_color';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'transport'   => 'postMessage',
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'color' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Color( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Background color', 'eltron-features' ),
	'priority'    => 20,
) ) );

// ------
$wp_customize->add_control( new Eltron_Customize_Control_HR( $wp_customize, 'hr_woocommerce_products_grid_item', array(
	'section'     => $section,
	'settings'    => array(),
	'priority'    => 20,
) ) );

// Same height items in a row
$key = 'woocommerce_products_grid_same_height_items';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'toggle' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Toggle( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Same height items in a row', 'eltron-features' ),
	'description' => esc_html__( 'Make all items in a row have same height. The add to cart button will be pushed at the bottom of the item.', 'eltron-features' ),
	'priority'    => 20,
) ) );

/**
 * ====================================================
 * Product Image
 * ====================================================
 */

// Heading: Product Image
$wp_customize->add_control( new Eltron_Customize_Control_Heading( $wp_customize, 'heading_woocommerce_products_grid_item_image', array(
	'section'     => $section,
	'settings'    => array(),
	'label'       => esc_html__( 'Product Image', 'eltron-features' ),
	'priority'    => 30,
) ) );

// Ignore padding
$key = 'woocommerce_products_grid_item_image_ignore_padding';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'toggle' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Toggle( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Ignore padding', 'eltron-features' ),
	'priority'    => 30,
) ) );

// Enable alternate hover image
$key = 'woocommerce_products_grid_item_alt_hover_image';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'toggle' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Toggle( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Enable alternate hover image', 'eltron-features' ),
	'description' => esc_html__( 'When product thumbnail is hovered, the main image will switch to the 1st image of defined "Product gallery". If there is no image found, the main product thumbnail will remain displayed.', 'eltron-features' ),
	'priority'    => 30,
) ) );