<?php
/**
 * Eltron Pro module: Blocks Admin page
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

class Eltron_Pro_Module_WooCommerce_Layout_Plus_Admin {

	/**
	 * Singleton instance
	 *
	 * @var Eltron_Pro_Module_WooCommerce_Layout_Plus_Admin
	 */
	private static $instance;

	/**
	 * ====================================================
	 * Singleton & constructor functions
	 * ====================================================
	 */

	/**
	 * Get singleton instance.
	 *
	 * @return Eltron_Pro_Module_WooCommerce_Layout_Plus_Admin
	 */
	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
	 * Class constructor
	 */
	protected function __construct() {
		// Page Settings
		add_action( 'eltron/admin/metabox/page_settings/fields', array( $this, 'render_page_settings_fields__product' ), 10, 2 );
	}
	
	/**
	 * ====================================================
	 * Hook functions
	 * ====================================================
	 */

	/**
	 * Render "Product Layout" options on Page Settings meta box.
	 *
	 * @param WP_Post|WP_Term $obj
	 * @param string $tab
	 */
	public function render_page_settings_fields__product( $obj, $tab ) {
		if ( 'woocommerce-single' !== $tab ) {
			return;
		}

		$option_key = 'eltron_page_settings';

		$values = get_post_meta( $obj->ID, '_' . $option_key, true );

		$keys = array(
			'woocommerce_single_breadcrumb' => esc_html__( 'Show breadcrumb', 'eltron-features' ),
			'woocommerce_single_gallery' => esc_html__( 'Show gallery', 'eltron-features' ),
			'woocommerce_single_tabs' => esc_html__( 'Show tabs', 'eltron-features' ),
			'woocommerce_single_up_sells' => esc_html__( 'Show up-sells', 'eltron-features' ),
			'woocommerce_single_related' => esc_html__( 'Show related products', 'eltron-features' ),
		);

		foreach ( $keys as $key => $label ) : ?>
			<div class="eltron-admin-form-row">
				<div class="eltron-admin-form-label"><label><?php echo $label; // WPCS: XSS OK ?></label></div>
				<div class="eltron-admin-form-field">
					<?php
					Eltron_Admin_Fields::render_field( array(
						'name'        => $option_key . '[' . $key . ']',
						'type'        => 'select',
						'choices'     => array(
							''  => esc_html__( '(Customizer)', 'eltron-features' ),
							'0' => esc_html__( '&#x2718; No', 'eltron-features' ),
							'1' => esc_html__( '&#x2714; Yes', 'eltron-features' ),
						),
						'value'       => eltron_array_value( $values, $key ),
					) );
					?>
				</div>
			</div>

			<?php if ( 'woocommerce_single_gallery' === $key ) : ?>
				<div class="eltron-admin-form-row">
					<div class="eltron-admin-form-label"><label><?php esc_html_e( 'Gallery layout', 'eltron-features' ); ?></label></div>
					<div class="eltron-admin-form-field">
						<?php
						Eltron_Admin_Fields::render_field( array(
							'name'        => $option_key . '[woocommerce_single_gallery_layout]',
							'type'        => 'radioimage',
							'choices'     => array(
								''           => array(
									'label' => esc_html__( '(Customizer)', 'eltron-features' ),
									'image' => ELTRON_IMAGES_URL . '/customizer/customizer.svg',
								),
								'bottom' => array(
									'label' => esc_html__( 'Bottom', 'eltron-features' ),
									'image' => ELTRON_PRO_URI . 'assets/images/customizer/woocommerce-gallery-layout--bottom.svg',
								),
								'left'   => array(
									'label' => is_rtl() ? esc_html__( 'Right', 'eltron-features' ) : esc_html__( 'Left', 'eltron-features' ),
									'image' => ELTRON_PRO_URI . 'assets/images/customizer/woocommerce-gallery-layout--left.svg',
								),
								'right'  => array(
									'label' => is_rtl() ? esc_html__( 'Left', 'eltron-features' ) : esc_html__( 'Right', 'eltron-features' ),
									'image' => ELTRON_PRO_URI . 'assets/images/customizer/woocommerce-gallery-layout--right.svg',
								),
							),
							'value'       => eltron_array_value( $values, 'woocommerce_single_gallery_layout' ),
						) );
						?>
					</div>
				</div>
			<?php endif; ?>
		<?php endforeach;
	}
}

Eltron_Pro_Module_WooCommerce_Layout_Plus_Admin::instance();