<?php
/**
 * Customizer settings: WooCommerce > Cart Page
 *
 * @package Eltron Pro
 **/

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$section = 'woocommerce_cart';

/**
 * ====================================================
 * Checkout Button
 * ====================================================
 */

// ------
$wp_customize->add_control( new Eltron_Customize_Control_HR( $wp_customize, 'hr_woocommerce_cart_sticky_button', array(
	'section'     => $section,
	'settings'    => array(),
	'priority'    => 30,
) ) );

// Enable sticky checkout button on mobile
$key = 'woocommerce_cart_mobile_sticky_checkout_button';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'toggle' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Toggle( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Enable sticky checkout button on mobile', 'eltron-features' ),
	'description' => esc_html__( 'When on tablet and mobile device, the checkout button will stick / float at bottom of screen. This might help your mobile users to checkout faster and increase your conversion.', 'eltron-features' ),
	'priority'    => 30,
) ) );