<?php
/**
 * Customizer settings: WooCommerce > AJAX Add To Cart
 *
 * @package Eltron Pro
 **/

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$section = 'woocommerce_ajax_add_to_cart';

/**
 * ====================================================
 * AJAX Add To Cart
 * ====================================================
 */

// Enable AJAX Add to Cart on products grid
$wp_customize->add_control( new Eltron_Customize_Control_Blank( $wp_customize, 'notice_woocommerce_ajax_add_to_cart_on_products_grid', array(
	'section'     => $section,
	'settings'    => array(),
	'description' => '<div class="notice notice-info notice-alt inline"><p>' . esc_html__( 'To enable AJAX Add to Cart on products catalog, please use native WooCommerce setting on WooCommerce > Settings > Products > General > Add to cart behavior.', 'eltron-features' ) . '</p></div>',
	'priority'    => 10,
) ) );

// Enable AJAX Add to Cart on product page
$key = 'woocommerce_single_ajax_add_to_cart';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'toggle' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Toggle( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Enable AJAX Add To Cart on product page', 'eltron-features' ),
	'description' => esc_html__( 'This will be applied to all single product pages and the Quick View popup.', 'eltron-features' ),
	'priority'    => 10,
) ) );

// Show cart on header after succeed
$key = 'woocommerce_ajax_added_to_cart_open_header_cart';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'toggle' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Toggle( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Show cart on header after succeed', 'eltron-features' ),
	'description' => esc_html__( 'After products added to cart, show the cart widget on header.', 'eltron-features' ),
	'priority'    => 10,
) ) );