<?php
/**
 * Customizer & Front-End modification rules.
 *
 * @package Eltron Pro
 **/

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$add = array();

/**
 * ====================================================
 * Header > Vertical Bar
 * ====================================================
 */

$add['header_vertical_bar_position'] = array(
	array(
		'type'     => 'class',
		'element'  => '.eltron-header-vertical',
		'pattern'  => 'eltron-header-vertical-position-$',
	),
);
$add['header_vertical_bar_alignment'] = array(
	array(
		'type'     => 'class',
		'element'  => '.eltron-header-vertical',
		'pattern'  => 'eltron-text-align-$',
	),
);

$add['header_vertical_bar_width'] = array(
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-vertical-display-fixed, .eltron-header-vertical-bar',
		'property' => 'width',
	),
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-vertical-display-fixed.eltron-header-vertical-position-left ~ #canvas',
		'property' => 'margin-left',
		'media'    => '@media screen and (min-width: 1024px)',
	),
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-vertical-display-fixed.eltron-header-vertical-position-right ~ #canvas',
		'property' => 'margin-right',
		'media'    => '@media screen and (min-width: 1024px)',
	),
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-vertical-display-off-canvas.eltron-popup-active.eltron-header-vertical-position-left ~ #canvas',
		'property' => 'transform',
		'pattern'  => 'translate( $, 0 )',
	),
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-vertical-display-off-canvas.eltron-popup-active.eltron-header-vertical-position-right ~ #canvas',
		'property' => 'transform',
		'pattern'  => 'translate( -$, 0 )',
	),
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-vertical-display-full-screen .eltron-header-section-vertical-column',
		'property' => 'width',
	),

	// alignwide
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-vertical-display-fixed ~ .eltron-canvas .eltron-content-layout-narrow .alignwide',
		'property' => 'max-width',
		'pattern'  => 'calc( 100vw - $ )',
		'media'    => '@media screen and (min-width: 1024px)',
	),
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-vertical-display-fixed ~ .eltron-canvas .eltron-content-layout-narrow .alignwide',
		'property' => 'margin-left',
		'pattern'  => 'calc( -50vw + 50% + ( $ / 2 ) )',
		'media'    => '@media screen and (min-width: 1024px) and (max-width: ' . ( intval( eltron_get_theme_mod( 'container_width' ) ) + intval( eltron_get_theme_mod( 'header_vertical_bar_width' ) ) ) . 'px)', // currently can't find better way to do the media query.
	),
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-vertical-display-fixed ~ .eltron-canvas .eltron-content-layout-narrow .alignwide',
		'property' => 'margin-right',
		'pattern'  => 'calc( -50vw + 50% + ( $ / 2 ) )',
		'media'    => '@media screen and (min-width: 1024px) and (max-width: ' . ( intval( eltron_get_theme_mod( 'container_width' ) ) + intval( eltron_get_theme_mod( 'header_vertical_bar_width' ) ) ) . 'px)', // currently can't find better way to do the media query.
	),

	// alignfull
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-vertical-display-fixed ~ .eltron-canvas .eltron-content-layout-narrow .alignfull, .eltron-header-vertical-display-fixed ~ .eltron-canvas .eltron-content-layout-wide .alignfull',
		'property' => 'max-width',
		'pattern'  => 'calc( 100vw - $ )',
		'media'    => '@media screen and (min-width: 1024px)',
	),
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-vertical-display-fixed ~ .eltron-canvas .eltron-content-layout-narrow .alignfull, .eltron-header-vertical-display-fixed ~ .eltron-canvas .eltron-content-layout-wide .alignfull',
		'property' => 'margin-left',
		'pattern'  => 'calc( -50vw + 50% + ( $ / 2 ) )',
		'media'    => '@media screen and (min-width: 1024px)',
	),
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-vertical-display-fixed ~ .eltron-canvas .eltron-content-layout-narrow .alignfull, .eltron-header-vertical-display-fixed ~ .eltron-canvas .eltron-content-layout-wide .alignfull',
		'property' => 'margin-right',
		'pattern'  => 'calc( -50vw + 50% + ( $ / 2 ) )',
		'media'    => '@media screen and (min-width: 1024px)',
	),
);
$add['header_vertical_bar_padding'] = array(
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-vertical-bar-inner',
		'property' => 'padding',
	),
);
$add['header_vertical_bar_border'] = array(
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-vertical-bar-inner',
		'property' => 'border-width',
	),
);

$add['header_vertical_bar_items_gutter'] = array(
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-vertical-bar .eltron-header-section-vertical-row > *',
		'property' => 'padding',
		'pattern'  => '$ 0',
	),
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-vertical-bar .eltron-header-section-vertical-column',
		'property' => 'margin',
		'pattern'  => '-$ 0',
	),
);

foreach ( array( 'font_family', 'font_weight', 'font_style', 'text_transform', 'font_size', 'line_height', 'letter_spacing' ) as $prop ) {
	$add['header_vertical_bar_' . $prop ] = array(
		array(
			'type'     => 'font_family' === $prop ? 'font' : 'css',
			'element'  => '.eltron-header-vertical-bar',
			'property' => str_replace( '_', '-', $prop),
		),
	);
}

foreach ( array( 'font_family', 'font_weight', 'font_style', 'text_transform', 'font_size', 'line_height', 'letter_spacing' ) as $prop ) {
	$add['header_vertical_bar_menu_' . $prop ] = array(
		array(
			'type'     => 'font_family' === $prop ? 'font' : 'css',
			'element'  => '.eltron-header-vertical-bar .menu .menu-item > .eltron-menu-item-link, .eltron-header-vertical-bar .menu-item > .eltron-toggle',
			'property' => str_replace( '_', '-', $prop),
		),
	);
}

foreach ( array( 'font_family', 'font_weight', 'font_style', 'text_transform', 'font_size', 'line_height', 'letter_spacing' ) as $prop ) {
	$add['header_vertical_bar_submenu_' . $prop ] = array(
		array(
			'type'     => 'font_family' === $prop ? 'font' : 'css',
			'element'  => '.eltron-header-vertical-bar .sub-menu .menu-item > .eltron-menu-item-link, .eltron-header-vertical-bar .sub-menu .menu-item > .eltron-toggle',
			'property' => str_replace( '_', '-', $prop),
		),
	);
}

$add['header_vertical_bar_icon_size'] = array(
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-vertical-bar .eltron-menu-icon',
		'property' => 'font-size',
	),
);

$add['header_vertical_bar_shadow'] = array(
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-vertical-display-off-canvas.eltron-popup-active .eltron-header-vertical-bar, .eltron-header-vertical-display-fixed .eltron-header-vertical-bar',
		'property' => 'box-shadow',
	),
);

$add['header_vertical_bar_bg_color'] = array(
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-vertical-bar-inner',
		'property' => 'background-color',
	),
);
$add['header_vertical_bar_border_color'] = array(
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-vertical-bar *',
		'property' => 'border-color',
	),
);
$add['header_vertical_bar_text_color'] = array(
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-vertical-bar',
		'property' => 'color',
	),
);
$add['header_vertical_bar_link_text_color'] = array(
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-vertical-bar a:not(.button), .eltron-header-vertical-bar .eltron-toggle',
		'property' => 'color',
	),
);
$add['header_vertical_bar_link_hover_text_color'] = array(
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-vertical-bar a:not(.button):hover, .eltron-header-vertical-bar a:not(.button):focus, .eltron-header-vertical-bar .eltron-toggle:hover, .eltron-header-vertical-bar .eltron-toggle:focus',
		'property' => 'color',
	),
);

return $add;