<?php
/**
 * Customizer settings: Header > Transparent Header
 *
 * @package Eltron Pro
 **/

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$section = 'eltron_section_header_transparent';

/**
 * ====================================================
 * Desktop
 * ====================================================
 */

// Heading: Desktop Header
$wp_customize->add_control( new Eltron_Customize_Control_Heading( $wp_customize, 'heading_header_transparent', array(
	'section'     => $section,
	'settings'    => array(),
	'label'       => esc_html__( 'Desktop Header', 'eltron-features' ),
	'priority'    => 10,
) ) );

// Enable Transparent Header
$key = 'header_transparent';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'toggle' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Toggle( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Enable Transparent Header', 'eltron-features' ),
	'description' => sprintf(
		/* translators: %s: link to "Page Settings" section. */
		esc_html__( 'This is global default setting, optionally you can enable / disable Transparent Header for each page type via %s.', 'eltron-features' ),
		'<a href="' . esc_url( add_query_arg( 'autofocus[panel]', 'eltron_panel_page_settings' ) ) . '" class="eltron-customize-goto-control">' . esc_html__( 'Page Settings', 'eltron-features' ) . '</a>'
	),
	'priority'    => 10,
) ) );

$bars = array(
	'top_bar'    => esc_html__( 'Top Bar', 'eltron-features' ),
	'main_bar'   => esc_html__( 'Main Bar', 'eltron-features' ),
	'bottom_bar' => esc_html__( 'Bottom Bar', 'eltron-features' )
);
foreach ( $bars as $bar => $label ) {
	// ------
	$wp_customize->add_control( new Eltron_Customize_Control_HR( $wp_customize, 'hr_header_' . $bar . '_transparent_colors', array(
		'section'     => $section,
		'settings'    => array(),
		'priority'    => 10,
	) ) );

	// --- Blank: Colors
	$wp_customize->add_control( new Eltron_Customize_Control_Blank( $wp_customize, 'label_header_' . $bar . '_transparent_colors', array(
		'section'     => $section,
		'settings'    => array(),
		'label'       => strtoupper( $label ),
		'priority'    => 10,
	) ) );

	// Colors
	$colors = array(
		'header_' . $bar . '_transparent_bg_color'     => esc_html__( 'Transparent header: Background color', 'eltron-features' ),
		'header_' . $bar . '_transparent_border_color' => esc_html__( 'Transparent header: Border color', 'eltron-features' ),
	);
	foreach ( $colors as $key => $label ) {
		$wp_customize->add_setting( $key, array(
			'default'     => eltron_array_value( $defaults, $key ),
			'transport'   => 'postMessage',
			'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'color' ),
		) );
		$wp_customize->add_control( new Eltron_Customize_Control_Color( $wp_customize, $key, array(
			'section'     => $section,
			'label'       => $label,
			'priority'    => 10,
		) ) );
	}
}

/**
 * ====================================================
 * Colors
 * ====================================================
 */

// Heading: Mobile Header
$wp_customize->add_control( new Eltron_Customize_Control_Heading( $wp_customize, 'heading_header_mobile_transparent', array(
	'section'     => $section,
	'settings'    => array(),
	'label'       => esc_html__( 'Mobile Header', 'eltron-features' ),
	'priority'    => 20,
) ) );

// Enable Transparent Mobile Header
$key = 'header_mobile_transparent';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'toggle' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Toggle( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Enable Transparent Mobile Header', 'eltron-features' ),
	'description' => sprintf(
		/* translators: %s: link to "Page Settings" section. */
		esc_html__( 'This is global default setting, optionally you can enable / disable Transparent Header for each page type via %s.', 'eltron-features' ),
		'<a href="' . esc_url( add_query_arg( 'autofocus[panel]', 'eltron_panel_page_settings' ) ) . '" class="eltron-customize-goto-control">' . esc_html__( 'Page Settings', 'eltron-features' ) . '</a>'
	),
	'priority'    => 20,
) ) );

// ------
$wp_customize->add_control( new Eltron_Customize_Control_HR( $wp_customize, 'hr_header_mobile_transparent_colors', array(
	'section'     => $section,
	'settings'    => array(),
	'priority'    => 20,
) ) );

// --- Blank: Label colors
$wp_customize->add_control( new Eltron_Customize_Control_Blank( $wp_customize, 'label_header_mobile_transparent_colors', array(
	'section'     => $section,
	'settings'    => array(),
	'label'       => strtoupper( esc_html__( 'Mobile Main Bar', 'eltron-features' ) ),
	'priority'    => 20,
) ) );

// Colors
$colors = array(
	'header_mobile_main_bar_transparent_bg_color'     => esc_html__( 'Transparent header: Background color', 'eltron-features' ),
	'header_mobile_main_bar_transparent_border_color' => esc_html__( 'Transparent header: Border color', 'eltron-features' ),
);
foreach ( $colors as $key => $label ) {
	$wp_customize->add_setting( $key, array(
		'default'     => eltron_array_value( $defaults, $key ),
		'transport'   => 'postMessage',
		'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'color' ),
	) );
	$wp_customize->add_control( new Eltron_Customize_Control_Color( $wp_customize, $key, array(
		'section'     => $section,
		'label'       => $label,
		'priority'    => 20,
	) ) );
}