<?php
/**
 * Eltron Pro module: Transparent Header
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

class Eltron_Pro_Module_Header_Transparent extends Eltron_Pro_Module {

	/**
	 * Module name
	 *
	 * @var string
	 */
	const MODULE_SLUG = 'header-transparent';

	/**
	 * ====================================================
	 * Singleton & constructor functions
	 * ====================================================
	 */

	/**
	 * Class constructor
	 */
	protected function __construct() {
		parent::__construct();

		// Dynamic CSS
		add_filter( 'eltron/frontend/pro_dynamic_css', array( $this, 'add_dynamic_css' ) );

		// Customizer settings & values
		add_action( 'customize_register', array( $this, 'register_customizer_settings' ) );
		add_filter( 'eltron/customizer/setting_defaults', array( $this, 'add_customizer_setting_defaults' ) );
		add_filter( 'eltron/customizer/setting_postmessages', array( $this, 'add_customizer_setting_postmessages' ) );

		// Metabox
		add_action( 'eltron/admin/metabox/page_settings/fields', array( $this, 'add_metabox_page_settings_fields' ), 10, 2 );

		// Template filters
		add_filter( 'eltron/frontend/header_classes', array( $this, 'add_header_classes' ) );
		add_filter( 'eltron/frontend/header_mobile_classes', array( $this, 'add_header_mobile_classes' ) );

		// Page Settings
		add_filter( 'eltron/dataset/fallback_page_settings', array( $this, 'add_fallback_page_settings' ) );
	}
	
	/**
	 * ====================================================
	 * Hook functions
	 * ====================================================
	 */

	/**
	 * Add dynamic CSS from customizer settings into the inline CSS.
	 *
	 * @param string $css
	 * @return string
	 */
	public function add_dynamic_css( $css ) {
		// Skip adding dynamic CSS on customizer preview frame.
		if ( is_customize_preview() ) {
			return $css;
		}

		$postmessages = include( ELTRON_PRO_DIR . '/inc/modules/' . self::MODULE_SLUG . '/customizer/postmessages.php' );
		$defaults = include( ELTRON_PRO_DIR . '/inc/modules/' . self::MODULE_SLUG . '/customizer/defaults.php' );

		$css .= Eltron_Customizer::instance()->convert_postmessages_to_css_string( $postmessages, $defaults );

		return $css;
	}

	/**
	 * Register customizer sections, settings, and controls.
	 *
	 * @param WP_Customize_Manager $wp_customize
	 */
	public function register_customizer_settings( $wp_customize ) {
		$defaults = Eltron_Customizer::instance()->get_setting_defaults();

		require_once( ELTRON_PRO_DIR . 'inc/modules/' . self::MODULE_SLUG . '/customizer/options/_sections.php' );
		require_once( ELTRON_PRO_DIR . 'inc/modules/' . self::MODULE_SLUG . '/customizer/options/header--transparent.php' );
		require_once( ELTRON_PRO_DIR . 'inc/modules/' . self::MODULE_SLUG . '/customizer/options/header--alt-colors.php' );
		require_once( ELTRON_PRO_DIR . 'inc/modules/' . self::MODULE_SLUG . '/customizer/options/page-settings.php' );
	}
	
	/**
	 * Add default values for all Customizer settings.
	 *
	 * @param array $defaults
	 * @return array
	 */
	public function add_customizer_setting_defaults( $defaults = array() ) {
		$add = include( ELTRON_PRO_DIR . 'inc/modules/' . self::MODULE_SLUG . '/customizer/defaults.php' );

		return array_merge_recursive( $defaults, $add );
	}

	/**
	 * Add postmessage rules for some Customizer settings.
	 *
	 * @param array $postmessages
	 * @return array
	 */
	public function add_customizer_setting_postmessages( $postmessages = array() ) {
		$add = include( ELTRON_PRO_DIR . 'inc/modules/' . self::MODULE_SLUG . '/customizer/postmessages.php' );

		return array_merge_recursive( $postmessages, $add );
	}

	/**
	 * Add Page Settings metabox fields.
	 */
	public function add_metabox_page_settings_fields( $obj, $tab ) {
		if ( 'header' !== $tab ) {
			return;
		}

		$option_key = 'eltron_page_settings';

		if ( is_a( $obj, 'WP_Post' ) ) {
			$values = get_post_meta( $obj->ID, '_' . $option_key, true );
		} elseif ( is_a( $obj, 'WP_Term' ) ) {
			$values = get_term_meta( $obj->term_id, $option_key, true );
		} else {
			$values = array();
		}

		?>
		<div class="eltron-admin-form-row">
			<div class="eltron-admin-form-label"><label><?php esc_html_e( 'Transparent desktop header', 'eltron-features' ); ?></label></div>
			<div class="eltron-admin-form-field">
				<?php
				$key = 'header_transparent';
				Eltron_Admin_Fields::render_field( array(
					'name'        => $option_key . '[' . $key . ']',
					'type'        => 'select',
					'choices'     => array(
						''  => esc_html__( '(Customizer)', 'eltron-features' ),
						'0' => esc_html__( 'No', 'eltron-features' ),
						'1' => esc_html__( 'Yes', 'eltron-features' ),
					),
					'value'       => eltron_array_value( $values, $key ),
				) );
				?>
			</div>
		</div>

		<div class="eltron-admin-form-row">
			<div class="eltron-admin-form-label"><label><?php esc_html_e( 'Transparent mobile header', 'eltron-features' ); ?></label></div>
			<div class="eltron-admin-form-field">
				<?php
				$key = 'header_mobile_transparent';
				Eltron_Admin_Fields::render_field( array(
					'name'        => $option_key . '[' . $key . ']',
					'type'        => 'select',
					'choices'     => array(
						''  => esc_html__( '(Customizer)', 'eltron-features' ),
						'0' => esc_html__( 'No', 'eltron-features' ),
						'1' => esc_html__( 'Yes', 'eltron-features' ),
					),
					'value'       => eltron_array_value( $values, $key ),
				) );
				?>
			</div>
		</div>
		<?php
	}

	/**
	 * Add custom classes to the array of main header classes.
	 *
	 * @param array $classes
	 * @return array
	 */
	public function add_header_classes( $classes ) {
		if ( intval( eltron_get_current_page_setting( 'header_transparent' ) ) ) {
			$classes['transparent'] = esc_attr( 'eltron-header-main-transparent eltron-header-transparent' );
		}

		return $classes;
	}

	/**
	 * Add custom classes to the array of mobile header classes.
	 *
	 * @param array $classes
	 * @return array
	 */
	public function add_header_mobile_classes( $classes ) {
		if ( intval( eltron_get_current_page_setting( 'header_mobile_transparent' ) ) ) {
			$classes['transparent'] = esc_attr( 'eltron-header-mobile-transparent eltron-header-transparent' );
		}

		return $classes;
	}

	/**
	 * Modify fallback page settings.
	 *
	 * @param array $settings
	 * @return array
	 */
	public function add_fallback_page_settings( $settings ) {
		$settings['header_transparent'] = eltron_get_theme_mod( 'header_transparent', 0 );
		$settings['header_mobile_transparent'] = eltron_get_theme_mod( 'header_mobile_transparent', 0 );

		return $settings;
	}
}

Eltron_Pro_Module_Header_Transparent::instance();