<?php
/**
 * Customizer settings: Page Settings
 *
 * @package Eltron
 **/

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

foreach ( Eltron_Customizer::instance()->get_all_page_settings_types() as $ps_type => $ps_data ) {
	$section = 'eltron_section_page_settings_' . $ps_type;
	$option_key = 'page_settings_' . $ps_type;

	// Get default value (array) of the option key.
	$default = eltron_array_value( $defaults, $option_key, array() );
	if ( ! is_array( $default ) ) {
		$default = array();
	}

	/**
	 * ====================================================
	 * Header
	 * ====================================================
	 */

	// ------
	$wp_customize->add_control( new Eltron_Customize_Control_HR( $wp_customize, 'hr_page_settings_' . $ps_type . '_header_sticky', array(
		'section'     => $section,
		'settings'    => array(),
		'priority'    => 22,
	) ) );

	// Sticky desktop header
	$subkey = 'header_sticky';
	$key = $option_key . '[' . $subkey . ']';
	$wp_customize->add_setting( $key, array(
		'default'     => eltron_array_value( $default, $subkey ),
		'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'select' ),
	) );
	$wp_customize->add_control( $key, array(
		'type'        => 'select',
		'section'     => $section,
		'label'       => esc_html__( 'Sticky desktop header', 'eltron-features' ),
		'choices'     => array(
			''  => esc_html__( '(Default)', 'eltron-features' ),
			'0' => esc_html__( '&#x2718; Disabled', 'eltron-features' ),
			'1' => esc_html__( '&#x2714; Enabled', 'eltron-features' ),
		),
		'priority'    => 22,
	) );

	// Sticky mobile header
	$subkey = 'header_mobile_sticky';
	$key = $option_key . '[' . $subkey . ']';
	$wp_customize->add_setting( $key, array(
		'default'     => eltron_array_value( $default, $subkey ),
		'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'select' ),
	) );
	$wp_customize->add_control( $key, array(
		'type'        => 'select',
		'section'     => $section,
		'label'       => esc_html__( 'Sticky mobile header', 'eltron-features' ),
		'choices'     => array(
			''  => esc_html__( '(Default)', 'eltron-features' ),
			'0' => esc_html__( '&#x2718; Disabled', 'eltron-features' ),
			'1' => esc_html__( '&#x2714; Enabled', 'eltron-features' ),
		),
		'priority'    => 22,
	) );
}