<?php
/**
 * Customizer settings: Header > Contact Info
 *
 * @package Eltron Pro
 **/

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$section = 'eltron_section_header_contact';

/**
 * ====================================================
 * Contact Info
 * ====================================================
 */

// Heading: Contact Info
$wp_customize->add_control( new Eltron_Customize_Control_Heading( $wp_customize, 'heading_header_contact', array(
	'section'     => $section,
	'settings'    => array(),
	'label'       => esc_html__( 'Contact Info', 'eltron-features' ),
	'priority'    => 10,
) ) );

$items = array(
	'email'   => esc_html__( 'Email', 'eltron-features' ),
	'phone'   => esc_html__( 'Phone', 'eltron-features' ),
	'address' => esc_html__( 'Address', 'eltron-features' ),
	'time'    => esc_html__( 'Business Hours', 'eltron-features' ),
);

// Info items
$key = 'header_contact_items';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'transport'   => 'postMessage',
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'multiselect' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Builder( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Active items', 'eltron-features' ),
	'choices'     => $items,
	'priority'    => 10,
) ) );

foreach ( $items as $slug => $label ) {
	// ------
	$wp_customize->add_control( new Eltron_Customize_Control_HR( $wp_customize, 'hr_header_contact_' . $slug, array(
		'section'     => $section,
		'settings'    => array(),
		'priority'    => 10,
	) ) );

	// Text
	$key = 'header_contact_' . $slug . '_text';
	$wp_customize->add_setting( $key, array(
		'default'     => eltron_array_value( $defaults, $key ),
		'transport'   => 'postMessage',
		'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'text' ),
	) );
	$wp_customize->add_control( $key, array(
		'section'     => $section,
		/* translators: %s: contact item name. */
		'label'       => sprintf( esc_html__( '%s text', 'eltron-features' ), $label ),
		'priority'    => 10,
	) );

	// Link
	$key = 'header_contact_' . $slug . '_url';
	$wp_customize->add_setting( $key, array(
		'default'     => eltron_array_value( $defaults, $key ),
		'transport'   => 'postMessage',
		'sanitize_callback' => 'esc_url_raw',
	) );
	$wp_customize->add_control( $key, array(
		'section'     => $section,
		/* translators: %s: contact item name. */
		'label'       => sprintf( esc_html__( '%s URL', 'eltron-features' ), $label ),
		/* translators: %1$s: contact item name. */
		'description' => sprintf( esc_html__( 'Leave it blank to display %1$s as a plain text.', 'eltron-features' ), $label ),
		'priority'    => 10,
	) );
}

// Selective Refresh
if ( isset( $wp_customize->selective_refresh ) ) {
	$settings = array( 'header_contact_items' );
	foreach ( $items as $slug => $label ) {
		$settings[] = 'header_contact_' . $slug . '_text';
		$settings[] = 'header_contact_' . $slug . '_url';
	}

	$wp_customize->selective_refresh->add_partial( 'header_contact', array(
		'settings'            => $settings,
		'selector'            => '.eltron-header-contact',
		'container_inclusive' => true,
		'render_callback'     => array( Eltron_Pro_Module_Header_Elements_Plus::instance(), 'render_header_element__contact' ),
		'fallback_refresh'    => false,
	) );
}