<?php
/**
 * Customizer & Front-End modification rules.
 *
 * @package Eltron Pro
 **/

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$add = array();

/**
 * ====================================================
 * Header > Alternate Header Colors
 * ====================================================
 */

foreach ( array( 'main_bar', 'top_bar', 'bottom_bar' ) as $bar ) {
	$slug = str_replace( '_', '-', $bar );

	$add['header_' . $bar . '_alt_bg_color'] = array(
		array(
			'type'     => 'css',
			'element'  => '.eltron-header-main-alt-colors .eltron-header-' . $slug . ':not(.eltron-sticky-in-view) .eltron-header-' . $slug . '-inner',
			'property' => 'background-color',
		),
	);
	$add['header_' . $bar . '_alt_border_color'] = array(
		array(
			'type'     => 'css',
			'element'  => '.eltron-header-main-alt-colors .eltron-header-' . $slug . ':not(.eltron-sticky-in-view) .eltron-header-' . $slug . '-inner',
			'property' => 'border-color',
		),
	);
	$add['header_' . $bar . '_alt_text_color'] = array(
		array(
			'type'     => 'css',
			'element'  => '.eltron-header-main-alt-colors .eltron-header-' . $slug . ':not(.eltron-sticky-in-view)',
			'property' => 'color',
		),
	);
	$add['header_' . $bar . '_alt_link_text_color'] = array(
		array(
			'type'     => 'css',
			'element'  => '.eltron-header-main-alt-colors .eltron-header-' . $slug . ':not(.eltron-sticky-in-view) a:not(.button), .eltron-header-main-alt-colors .eltron-header-' . $slug . ':not(.eltron-sticky-in-view) .eltron-toggle',
			'property' => 'color',
		),
	);
	$add['header_' . $bar . '_alt_link_hover_text_color'] = array(
		array(
			'type'     => 'css',
			'element'  => '.eltron-header-main-alt-colors .eltron-header-' . $slug . ':not(.eltron-sticky-in-view) a:not(.button):hover, .eltron-header-main-alt-colors .eltron-header-' . $slug . ':not(.eltron-sticky-in-view) a:not(.button):focus, .eltron-header-main-alt-colors .eltron-header-' . $slug . ':not(.eltron-sticky-in-view) .eltron-toggle:hover, .eltron-header-main-alt-colors .eltron-header-' . $slug . ':not(.eltron-sticky-in-view) .eltron-toggle:focus',
			'property' => 'color',
		),
	);

	$add['header_' . $bar . '_alt_menu_hover_highlight_color'] = array(
		array(
			'type'     => 'css',
			'element'  => '.eltron-header-main-alt-colors .eltron-header-' . $slug . ':not(.eltron-sticky-in-view):not(.eltron-header-menu-highlight-none) .eltron-header-menu > .menu > .menu-item > .eltron-menu-item-link:hover:after, .eltron-header-main-alt-colors .eltron-header-' . $slug . ':not(.eltron-sticky-in-view):not(.eltron-header-menu-highlight-none) .eltron-header-menu > .menu > .menu-item > .eltron-menu-item-link:focus:after',
			'property' => 'background-color',
		),
	);
	$add['header_' . $bar . '_alt_menu_hover_highlight_text_color'] = array(
		array(
			'type'     => 'css',
			'element'  => '.eltron-header-main-alt-colors .eltron-header-' . $slug . ':not(.eltron-sticky-in-view):not(.eltron-header-menu-highlight-none) .eltron-header-menu > .menu > .menu-item > .eltron-menu-item-link:hover, .eltron-header-main-alt-colors .eltron-header-' . $slug . ':not(.eltron-sticky-in-view):not(.eltron-header-menu-highlight-none) .eltron-header-menu > .menu > .menu-item > .eltron-menu-item-link:focus',
			'property' => 'color',
		),
	);
	$add['header_' . $bar . '_alt_menu_active_highlight_color'] = array(
		array(
			'type'     => 'css',
			'element'  => '.eltron-header-main-alt-colors .eltron-header-' . $slug . ':not(.eltron-sticky-in-view):not(.eltron-header-menu-highlight-none) .eltron-header-menu > .menu > .current-menu-item > .eltron-menu-item-link:after, .eltron-header-main-alt-colors .eltron-header-' . $slug . ':not(.eltron-sticky-in-view):not(.eltron-header-menu-highlight-none) .eltron-header-menu > .menu > .current-menu-ancestor > .eltron-menu-item-link:after',
			'property' => 'background-color',
		),
	);
	$add['header_' . $bar . '_alt_menu_active_highlight_text_color'] = array(
		array(
			'type'     => 'css',
			'element'  => '.eltron-header-main-alt-colors .eltron-header-' . $slug . ':not(.eltron-sticky-in-view):not(.eltron-header-menu-highlight-none) .eltron-header-menu > .menu > .current-menu-item > .eltron-menu-item-link, .eltron-header-main-alt-colors .eltron-header-' . $slug . ':not(.eltron-sticky-in-view):not(.eltron-header-menu-highlight-none) .eltron-header-menu > .menu > .current-menu-ancestor > .eltron-menu-item-link',
			'property' => 'color',
		),
	);

	$add['header_' . $bar . '_alt_transparent_bg_color'] = array(
		array(
			'type'     => 'css',
			'element'  => '.eltron-header-main-alt-colors.eltron-header-main-transparent.eltron-header-transparent .eltron-header-' . $slug . ':not(.eltron-sticky-in-view) .eltron-header-' . $slug . '-inner',
			'property' => 'background-color',
		),
	);
	$add['header_' . $bar . '_alt_transparent_border_color'] = array(
		array(
			'type'     => 'css',
			'element'  => '.eltron-header-main-alt-colors.eltron-header-main-transparent.eltron-header-transparent .eltron-header-' . $slug . ':not(.eltron-sticky-in-view) .eltron-header-' . $slug . '-inner',
			'property' => 'border-color',
		),
	);
}

$add['header_mobile_main_bar_alt_bg_color'] = array(
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-mobile-alt-colors .eltron-header-mobile-main-bar:not(.eltron-sticky-in-view) .eltron-header-mobile-main-bar-inner',
		'property' => 'background-color',
	),
);
$add['header_mobile_main_bar_alt_border_color'] = array(
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-mobile-alt-colors .eltron-header-mobile-main-bar:not(.eltron-sticky-in-view) .eltron-header-mobile-main-bar-inner',
		'property' => 'border-color',
	),
);
$add['header_mobile_main_bar_alt_link_text_color'] = array(
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-mobile-alt-colors .eltron-header-mobile-main-bar:not(.eltron-sticky-in-view) a:not(.button), .eltron-header-mobile-alt-colors .eltron-header-mobile-main-bar:not(.eltron-sticky-in-view) .eltron-toggle',
		'property' => 'color',
	),
);
$add['header_mobile_main_bar_alt_link_hover_text_color'] = array(
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-mobile-alt-colors .eltron-header-mobile-main-bar:not(.eltron-sticky-in-view) a:not(.button):hover, .eltron-header-mobile-alt-colors .eltron-header-mobile-main-bar:not(.eltron-sticky-in-view) a:not(.button):focus, .eltron-header-mobile-alt-colors .eltron-header-mobile-main-bar:not(.eltron-sticky-in-view) .eltron-toggle:hover, .eltron-header-mobile-alt-colors .eltron-header-mobile-main-bar:not(.eltron-sticky-in-view) .eltron-toggle:focus',
		'property' => 'color',
	),
);
$add['header_mobile_main_bar_alt_transparent_bg_color'] = array(
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-mobile-alt-colors.eltron-header-mobile-transparent.eltron-header-transparent .eltron-header-mobile-main-bar:not(.eltron-sticky-in-view) .eltron-header-mobile-main-bar-inner',
		'property' => 'background-color',
	),
);
$add['header_mobile_main_bar_alt_transparent_border_color'] = array(
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-mobile-alt-colors.eltron-header-mobile-transparent.eltron-header-transparent .eltron-header-mobile-main-bar:not(.eltron-sticky-in-view) .eltron-header-mobile-main-bar-inner',
		'property' => 'border-color',
	),
);

return $add;