<?php
/**
 * Customizer settings: Blog > Posts Index
 *
 * @package Eltron
 **/

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$section = 'eltron_section_blog_index';

/**
 * ====================================================
 * Posts Layout
 * ====================================================
 */

/**
 * Posts Layout (replacing the default one)
 */

$key = 'blog_index_loop_mode';

// Get default control.
$control = $wp_customize->get_control( $key );

$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'select' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_RadioImage( $wp_customize, $key, array(
	'section'     => $control->section,
	'label'       => $control->label,
	'choices'     => array_merge( $control->choices, array(
		'list'         => array(
			'label' => esc_html__( 'List', 'eltron-features' ),
			'image' => ELTRON_PRO_URI . 'assets/images/customizer/blog-layout--list.svg',
		),
	) ),
	'priority'    => $control->priority,
) ) );

// Edit entry list
$wp_customize->add_control( new Eltron_Customize_Control_Blank( $wp_customize, 'edit_entry_list', array(
	'section'     => $section,
	'settings'    => array(),
	'description' => '<a href="' . esc_url( add_query_arg( 'autofocus[section]', 'eltron_section_entry_list', remove_query_arg( 'autofocus' ) ) ) . '" class="eltron-customize-goto-control button button-secondary">' . esc_html__( 'Post Layout: List', 'eltron-features' ) . '</a>',
	'priority'    => 25,
) ) );