<?php


// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

define( 'ELTRON_PRO_VERSION', '1.0.8' );

define( 'ELTRON_VERSION_REQUIRED', '0.9' );

define( 'ELTRON_PRO_DIR', plugin_dir_path( __FILE__ ) );

define( 'ELTRON_PRO_URI', plugins_url( '/', __FILE__ ) );

define( 'ELTRON_PRO_FILE', plugin_basename( __FILE__ ) );


/**
 * Plugin initiation
 */

// Load the plugin if current template is "eltron".
if ( 'eltron' === get_template() ) {
	require_once( ELTRON_PRO_DIR . 'inc/class-eltron-pro.php' );
}

// Otherwise, show notice and abort. -- tt

/* Adding metaboxes -- tt */

// Only include metabox on post add/edit page and term add/edit page.
global $pagenow;
if ( in_array( $pagenow, array( 'post.php', 'post-new.php', 'edit-tags.php', 'term.php' ) ) ) {
	require_once( ELTRON_PRO_DIR . '/inc/class-eltron-admin-metabox-page-settings.php' );
}

function blvframework_page_boxes( $slug='', $post_type, $post ) {

	if( $slug != '') $slug = get_template();
	if( $slug != '') {
        $post_types = array_merge( array( 'post', 'page' ), get_post_types( array(
            'public'             => true,
            'publicly_queryable' => true,
            'rewrite'            => true,
            '_builtin'           => false,
        ), 'names' ) );
        $ignored_post_types = apply_filters( $slug .'/admin/metabox/page_settings/ignored_post_types', array() );
        $post_types = array_diff( $post_types, $ignored_post_types );
		add_meta_box(
			$slug .'_page_settings',
			/* translators: %s: theme name. */
			sprintf( esc_html__( 'Page Settings (%s)', 'eltronfm-features' ), ucfirst(get_template()) ),
			array( $this, 'render_meta_box__post' ),
			$post_types,
			'normal',
			'high'
		);
	}

}

function blvframework_page_boxes_add() {

        // Post meta box
        add_action(
            'add_meta_boxes',
            'blvframework_page_boxes',
            10,
            2
        );


}

add_filter( 'script_loader_tag', 'blvframework_add_defer_attribute_to_scripts', 10, 2 );
/**
 * Add 'defer' attribute to some scripts.
 *
 * @param string $tag
 * @param string $handle
 * @return string
 */
function blvframework_add_defer_attribute_to_scripts( $tag, $handle ) {

	$slug = get_template();

	$scripts_to_defer = apply_filters( $slug .'/frontend/defer_scripts', array() );

	foreach ( $scripts_to_defer as $script ) {
		if ( $script === $handle ) {
			return str_replace( ' src', ' defer src', $tag );
		}
	}

	return $tag;
}
