<?php
/**
 * Mobile header sections template.
 *
 * @package Eltron
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

?>
<div id="mobile-header" class="<?php echo esc_attr( implode( ' ', apply_filters( 'eltron/frontend/header_mobile_classes', array( 'eltron-header-mobile', 'eltron-header' ) ) ) ); ?>">
	<?php
	$elements = array();
	$count = 0;
	$cols = array( 'left', 'center', 'right' );

	foreach ( $cols as $col ) {
		$elements[ $col ] = eltron_get_theme_mod( 'header_mobile_elements_main_' . $col, array() );
		$count += count( $elements[ $col ] );
	}

	if ( 1 > $count ) {
		return;
	}

	$attrs_array = apply_filters( 'eltron/frontend/header_mobile_main_bar_attrs', array(
		'data-height' => intval( eltron_get_theme_mod( 'header_mobile_main_bar_height' ) ),
	) );
	$attrs = '';
	foreach ( $attrs_array as $key => $value ) {
		$attrs .= ' ' . $key . '="' . esc_attr( $value ) . '"';
	}

	?>
	<div id="eltron-header-mobile-main-bar" class="<?php echo esc_attr( implode( ' ', apply_filters( 'eltron/frontend/header_mobile_main_bar_classes', array( 'eltron-header-mobile-main-bar', 'eltron-header-section', 'eltron-section', 'eltron-section-default' ) ) ) ); ?>" <?php echo do_shortcode($attrs); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>>
		<div class="eltron-header-mobile-main-bar-inner eltron-section-inner">
			<div class="eltron-wrapper">
				<div class="eltron-header-mobile-main-bar-row eltron-header-row <?php echo esc_attr( ( 0 < count( $elements['center'] ) ) ? 'eltron-header-row-with-center' : '' ); ?>">
					<?php foreach ( $cols as $col ) : ?>
						<?php
						// Skip center column if it's empty
						if ( 'center' === $col && 0 === count( $elements[ $col ] ) ) {
							continue;
						}
						?>
						<div class="<?php echo esc_attr( 'eltron-header-mobile-main-bar-' . $col ); ?> eltron-header-column">
							<?php
							// Print all elements inside the column.
							foreach ( $elements[ $col ] as $element ) {
								eltron_header_element( $element );
							}
							?>
						</div>
					<?php endforeach; ?>
				</div>
			</div>
		</div>
	</div>
</div>