<?php
/**
 * Mobile header vertical toggle template.
 *
 * Passed variables:
 *
 * @type string $slug Header element slug.
 *
 * @package Eltron
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

?>
<div class="<?php echo esc_attr( 'eltron-header-' . $slug ); ?>">
	<button class="eltron-popup-toggle eltron-toggle" data-target="mobile-vertical-header" aria-expanded="false">
		<?php eltron_icon( 'menu', array( 'class' => 'eltron-menu-icon' ) ); ?>
		<span class="screen-reader-text"><?php esc_html_e( 'Mobile Menu', 'eltron' ); ?></span>
	</button>
</div>