<?php
/**
 * Header menu template.
 *
 * Passed variables:
 *
 * @type string $slug Header element slug.
 *
 * @package Eltron
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

?>
<nav class="<?php echo esc_attr( 'eltron-header-' . $slug ); ?> eltron-header-menu site-navigation" itemtype="https://schema.org/SiteNavigationElement" itemscope role="navigation" aria-label="<?php echo esc_attr( sprintf( esc_html__( 'Header Menu %s', 'eltron' ), str_replace( 'menu-', '', $slug ) ) ); ?>">
	<?php wp_nav_menu( array(
		'theme_location' => 'header-' . $slug,
		'menu_class'     => 'menu eltron-hover-menu',
		'container'      => false,
		'fallback_cb'    => 'eltron_unassigned_menu',
	) ); ?>
</nav>