<?php
/**
 * Header logo template.
 *
 * Passed variables:
 *
 * @type string $slug Header element slug.
 *
 * @package Eltron
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

?>
<div class="<?php echo esc_attr( 'eltron-header-' . $slug ); ?> site-branding menu">
	<<?php echo is_front_page() && is_home() ? 'h1' : 'div'; ?> class="site-title menu-item h1">
		<a href="<?php echo esc_url( apply_filters( 'eltron/frontend/logo_url', home_url( '/' ) ) ); ?>" rel="home" class="eltron-menu-item-link">
			<?php
			/**
			 * Hook: eltron/frontend/logo
			 *
			 * @hooked eltron_default_logo - 10
			 */
			do_action( 'eltron/frontend/logo' );
			?>
		</a>
	</<?php echo is_front_page() && is_home() ? 'h1' : 'div'; ?>>
</div>