<?php
/**
 * Main header section template.
 *
 * Passed variables:
 *
 * @type string $bar Header section bar slug (top/main/bottom).
 *
 * @package Eltron
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$elements = array();
$count = 0;
$cols = array( 'left', 'center', 'right' );

foreach ( $cols as $col ) {
	$elements[ $col ] = eltron_get_theme_mod( 'header_elements_' . $bar . '_' . $col, array() );
	$count += count( $elements[ $col ] );
}

if ( 1 > $count ) {
	return;
}

$attrs_array = apply_filters( 'eltron/frontend/header_' . $bar . '_bar_attrs', array(
	'data-height' => intval( eltron_get_theme_mod( 'header_' . $bar . '_bar_height' ) ),
) );
$attrs = '';
foreach ( $attrs_array as $key => $value ) {
	$attrs .= ' ' . $key . '="' . esc_attr( $value ) . '"';
}

?>
<div id="eltron-header-<?php echo esc_attr( $bar ); ?>-bar" class="<?php echo esc_attr( implode( ' ', apply_filters( 'eltron/frontend/header_' . $bar . '_bar_classes', array( 'eltron-header-' . $bar . '-bar', 'eltron-header-section', 'eltron-section' ) ) ) ); ?>" <?php echo do_shortcode($attrs); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>>
	<div class="eltron-header-<?php echo esc_attr( $bar ); ?>-bar-inner eltron-section-inner">
		<div class="eltron-wrapper">

			<?php
			// Top Bar (if merged).
			if ( 'main' === $bar && intval( eltron_get_theme_mod( 'header_top_bar_merged' ) ) ) {
				eltron_main_header__bar( 'top' );
			}
			?>

			<div class="eltron-header-<?php echo esc_attr( $bar ); ?>-bar-row eltron-header-row <?php echo esc_attr( ( 0 < count( $elements['center'] ) ) ? 'eltron-header-row-with-center' : '' ); ?>">
				<?php foreach ( $cols as $col ) : ?>
					<?php
					// Skip center column if it's empty
					if ( 'center' === $col && 0 === count( $elements[ $col ] ) ) {
						continue;
					}
					?>
					<div class="<?php echo esc_attr( 'eltron-header-' . $bar . '-bar-' . $col ); ?> eltron-header-column">
						<?php
						// Print all elements inside the column.
						foreach ( $elements[ $col ] as $element ) {
							eltron_header_element( $element );
						}
						?>
					</div>
				<?php endforeach; ?>
			</div>

			<?php
			// Bottom Bar (if merged).
			if ( 'main' === $bar && intval( eltron_get_theme_mod( 'header_bottom_bar_merged' ) ) ) {
				eltron_main_header__bar( 'bottom' );
			}
			?>

		</div>
	</div>
</div>