<?php
/**
 * Footer bottom section template.
 *
 * @package Eltron
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$cols = array( 'left', 'center', 'right' );

$elements = array();
$count = 0;

foreach ( $cols as $col ) {
	$elements[ $col ] = eltron_get_theme_mod( 'footer_elements_bottom_' . $col, array() );
	$count += empty( $elements[ $col ] ) ? 0 : count( $elements[ $col ] );
}

if ( 1 > $count ) {
	return;
}

?>
<div id="eltron-footer-bottom-bar" class="<?php echo esc_attr( implode( ' ', apply_filters( 'eltron/frontend/footer_bottom_bar_classes', array( 'eltron-footer-bottom-bar', 'site-info', 'eltron-footer-section', 'eltron-section' ) ) ) ); ?>">
	<div class="eltron-footer-bottom-bar-inner eltron-section-inner">
		<div class="eltron-wrapper">
			<div class="eltron-footer-bottom-bar-row eltron-footer-row <?php echo esc_attr( ( 0 < count( $elements['center'] ) ) ? 'eltron-footer-row-with-center' : '' ); ?>">
				<?php foreach ( $cols as $col ) : ?>
					<?php
					// Skip center column if it's empty
					if ( 'center' === $col && 0 === count( $elements[ $col ] ) ) {
						continue;
					}
					?>
					<div class="eltron-footer-bottom-bar-<?php echo esc_attr( $col ); ?> eltron-footer-bottom-bar-column">
						<?php
						// Print all elements inside the column.
						foreach ( $elements[ $col ] as $element ) {
							eltron_footer_element( $element );
						}
						?>
					</div>
				<?php endforeach; ?>
			</div>
		</div>
	</div>
</div>