<?php
/*
 * Template file for posts shortcode.
 * $temptt_t_vars is an array of custom parameters set for given post shortcode.
 */
if( is_array($temptt_t_vars) ) {
	$temptt_spl_vars2 = json_decode( $temptt_t_vars['temptt_var1'], true );
	if( is_array($temptt_spl_vars2) ) {
		extract( $temptt_spl_vars2 );
	}
}
/*
 * $spl_field1 is title.
 * $spl_field2 is button.
 * $spl_field3 is button target.
 * $spl_field4 is button link.
 * $spl_field5 is subtitle.
 * $spl_field6 is description.
 */
?>

<section id="blog" class="blog-section relative-position">
	<div class="background_overlay"></div>
	<div class="container">
        <div class="row">
			<div class="col-lg-4 col-md-12">
				<div class="blog-left-content">
					<div class="section-title-left">

						<?php if( '' != $spl_field5 ) { ?>
							<span class="title-tag"><img src="<?php echo get_template_directory_uri(); ?>/assets/icon/icon5.svg" alt="<?php esc_html_e('icon', 'eltron'); ?>" /><?php echo do_shortcode(wp_kses($spl_field5, eltron_tt_allowed_tags())); ?></span>
						<?php } ?>
						<?php if( '' != $spl_field1 ) { ?>
							<h2><?php echo do_shortcode(wp_kses($spl_field1, eltron_tt_allowed_tags())); ?></h2>
						<?php } ?>
					</div>
					<div class="blog-text-details">
						<?php if( '' != $spl_field6 ) { ?>
							<p><?php echo do_shortcode(wp_kses($spl_field6, eltron_tt_allowed_tags())); ?></p>
						<?php } ?>
						<?php if( '' != $spl_field2 ) { ?>
						<div class="b-read-more-btn text-center text-uppercase">
							<a href="<?php echo esc_url($spl_field4); ?>" <?php echo( ! empty( $spl_field3 ) ? ' target="' . $spl_field3 . '"' : '' ) ?> ><?php echo wp_kses($spl_field2, eltron_tt_allowed_tags()); ?><i class="flaticon-next"></i></a>
						</div>
						<?php } ?>
					</div>
				</div>
			</div>
	<?php
		// Posts are found
		if ( $posts->have_posts() ) {
			?>
			<div class="col-lg-8 col-md-12">
					<div class="blog-post-content clearfix">
			<?php
			while ( $posts->have_posts() ) :
				$posts->the_post();
				global $post;
			
				$user_id = get_the_author_meta( 'ID' );
				?>

				<div class="blog-post-item">
					<div class="blog-post-pic">
						<?php if ( has_post_thumbnail() ) : ?>
							<?php the_post_thumbnail('postsmall', array('class' => 'img-fluid')); ?>
						<?php endif; ?>
						<a class="blog-linker" href="<?php the_permalink(); ?>"></a>
					</div>
					<div class="blog-post-text">
						<?php the_title( sprintf( '<h3><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
						<div class="blog-meta">
							<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"><i class="icon-user"></i><?php the_author(); ?></a>
							<a href="<?php the_permalink(); ?>"><i class="icon-calendar"></i><?php echo get_the_date('M j, Y'); ?></a>
						</div>
						<div class="blog-more text-uppercase">
							<a href="<?php the_permalink(); ?>"><?php esc_html_e('full story ', 'eltron'); ?><i class="flaticon-next"></i></a>
						</div>
					</div>
				</div>
				<?php
			endwhile;
			?>
				</div>
			</div>
			<?php
		}
		// Posts not found
		else {
			echo '<h4>' . esc_html__( 'Posts not found', 'eltron' ) . '</h4>';
		}
	?>

        </div>
    </div>
</section>