<?php
/*
 * Template file for posts shortcode.
 * $temptt_t_vars is an array of custom parameters set for given post shortcode.
 */
if( is_array($temptt_t_vars) ) {
	$temptt_spl_vars2 = json_decode( $temptt_t_vars['temptt_var1'], true );
	if( is_array($temptt_spl_vars2) ) {
		extract( $temptt_spl_vars2 );
	}
}

/*
 * $spl_field1 is title.
 * $spl_field2 is button.
 * $spl_field3 is button target.
 * $spl_field4 is button link.
 * $spl_field5 is subtitle.
 * $spl_field6 is description.
 */

?>

<section id="project" class="project-section">
	<div class="container">
<?php
// Posts are found
if ( $posts->have_posts() ) {
?>		<div class="project-text-content">
			<div class="row">
				<div class="col-lg-4 col-md-12">
					<div class="section-title-left">
						<span class="title-tag"><img src="<?php echo get_template_directory_uri(); ?>/assets/icon/icon5.svg" alt="<?php esc_html_e('icon', 'eltron'); ?>" />
						<?php if( '' != $spl_field5 ) { ?>
							<?php echo do_shortcode(wp_kses($spl_field5, eltron_tt_allowed_tags())); ?>
						<?php } ?>
						</span>
						<?php if( '' != $spl_field1 ) { ?>
							<h2><?php echo do_shortcode(wp_kses($spl_field1, eltron_tt_allowed_tags())); ?></h2>
						<?php } ?>
					</div>
					<!-- title -->
				</div>
					<?php
					if($temptt_t_vars['temptt_show_filters'] == 'yes' ) {
					                $sub_cat_args = array('hide_empty' => 0, 'orderby' => 'ID');
					                $sub_cat_terms = get_terms('tt_portfolio_cats', $sub_cat_args);
					                if (!empty($sub_cat_terms) && !is_wp_error($sub_cat_terms)) { ?>
								<div class="col-lg-8 col-md-12">
									<div class="project-filter-btn ul-li text-center">
										<div class="button-group portfolio text-uppercase clearfix">
								            <?php if($temptt_t_vars['temptt_filter_all'] == 'yes' ) { ?>
											<button class="filter-button is-checked" data-filter="*"><?php esc_html_e('All', 'eltron');?></button>
										    <?php } ?>
								            <?php foreach ($sub_cat_terms as $sub_cat) {
							                print '<button class="filter-button" data-filter=".' . $sub_cat->slug . '">' . $sub_cat->name . '</button>';
										    } ?>
										</div>
									</div>
								</div>
					                <?php } ?>
					<?php } ?>
			</div>
		</div>
		<div class="grid <?php if($temptt_t_vars['temptt_show_filters'] == 'yes' ) echo ' project-filtering ';?> zoom-gallery clearfix row" data-isotope="{ &quot;masonry&quot;: { &quot;columnWidth&quot;: 0 } }">
			<div class="grid-sizer"></div>

	<?php
	while ( $posts->have_posts() ) :
		$posts->the_post();
		global $post;
	            $curent_term_array = wp_get_post_terms(get_the_ID(), 'tt_portfolio_cats');
	            $current_term_string = '';
	            foreach ($curent_term_array as $curent_term_item) {
	                $current_term_string .= ' ' . $curent_term_item->slug;

	            }

		/* Add class if bigger image width exists. */
			if ( has_post_thumbnail() )  {
			    $imgdata = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
			    $imgwidth = $imgdata[1]; // image's width
			    $wanted_width = 700;
			    if ( ($imgwidth > $wanted_width ) ) {
			        $img_width_class = 'grid-item-big';
			    } else {
			        $img_width_class = 'grid-item-width';
			    }
			}
		?>

			<div class="grid-item <?php echo esc_html($img_width_class); ?> <?php if($temptt_t_vars['temptt_show_filters'] == 'yes' ) echo esc_attr($current_term_string);?> " data-category="<?php if($temptt_t_vars['temptt_show_filters'] == 'yes' ) echo esc_attr($current_term_string);?>">
					<div class="projecct-img relative-position">
						<?php the_post_thumbnail('full', array('class' => 'img-fluid')); ?>
						<div class="project-item-text para-content headline">
							<?php the_title( sprintf( '<h3><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
						</div>
						<a class="popup-project"  data-lightbox="roadtrip" href="<?php the_post_thumbnail_url(); ?>"></a>
					</div>
			</div>


	<?php
	endwhile; ?>

		</div>
		<?php if($spl_field2 != '' ) { ?>
		<div class="project-more-btn text-uppercase">
			<a href="<?php echo esc_url($spl_field4); ?>" target="<?php echo esc_html($spl_field3); ?>"><?php echo wp_kses($spl_field2, eltron_tt_allowed_tags()); ?> <i class="flaticon-next"></i></a>
		</div>
		<?php } ?>
	<?php
	}
	// Posts not found
	else {
		echo '<h4>' . esc_html__( 'Portfolio Posts not found', 'eltron' ) . '</h4>';
	}
	?>
	</div>
</section>