<?php
/**
 * The template for displaying all single posts.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Eltron
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Header
 */
get_header();

/**
 * Primary - opening tag
 */
eltron_primary_open();

/**
 * Hook: eltron/frontend/before_main
 */
do_action( 'eltron/frontend/before_main' );

while ( have_posts() ) : the_post();

	// Render post content using "content" layout.
	eltron_get_template_part( 'entry' );

endwhile;

/**
 * Hook: eltron/frontend/after_main
 * 
 * @hooked eltron_single_post_author_bio - 10
 * @hooked eltron_single_post_navigation - 15
 * @hooked eltron_entry_comments - 20
 */
do_action( 'eltron/frontend/after_main' );

/**
 * Primary - closing tag
 */
eltron_primary_close();

/**
 * Sidebar
 */
get_sidebar();

/**
 * Footer
 */
get_footer();