<?php

/**
 * Customizer settings: Header > Search
 *
 * @package Eltron
 **/
// Prevent direct access.
if ( !defined( 'ABSPATH' ) ) {
    exit;
}
$section = 'eltron_section_header_search';
/**
 * ====================================================
 * Search Bar
 * ====================================================
 */
// Heading: Search Bar
$wp_customize->add_control( new Eltron_Customize_Control_Heading( $wp_customize, 'heading_header_search_bar', array(
    'section'  => $section,
    'settings' => array(),
    'label'    => esc_html__( 'Search Bar', 'eltron' ),
    'priority' => 10,
) ) );
// Search bar width
$key = 'header_search_bar_width';
$wp_customize->add_setting( $key, array(
    'default'           => eltron_array_value( $defaults, $key ),
    'transport'         => 'postMessage',
    'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'dimension' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Dimension( $wp_customize, $key, array(
    'section'  => $section,
    'label'    => esc_html__( 'Bar width', 'eltron' ),
    'units'    => array(
    'px' => array(
    'min'  => 100,
    'step' => 1,
),
),
    'priority' => 10,
) ) );
/**
 * ====================================================
 * Search Dropdown
 * ====================================================
 */
// Heading: Search Dropdown
$wp_customize->add_control( new Eltron_Customize_Control_Heading( $wp_customize, 'heading_header_search_dropdown', array(
    'section'  => $section,
    'settings' => array(),
    'label'    => esc_html__( 'Search Dropdown', 'eltron' ),
    'priority' => 20,
) ) );
// Search bar width
$key = 'header_search_dropdown_width';
$wp_customize->add_setting( $key, array(
    'default'           => eltron_array_value( $defaults, $key ),
    'transport'         => 'postMessage',
    'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'dimension' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Dimension( $wp_customize, $key, array(
    'section'  => $section,
    'label'    => esc_html__( 'Dropdown width', 'eltron' ),
    'units'    => array(
    'px' => array(
    'min'  => 100,
    'step' => 1,
),
),
    'priority' => 20,
) ) );