<?php
/**
 * Customizer settings: Header > Header Builder
 *
 * @package Eltron
 **/

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$section = 'eltron_section_header_builder';

/**
 * ====================================================
 * Builder
 * ====================================================
 */

ob_start(); ?>
<div class="eltron-responsive-switcher nav-tab-wrapper wp-clearfix">
	<a href="#" class="nav-tab preview-desktop eltron-responsive-switcher-button" data-device="desktop">
		<span class="dashicons dashicons-desktop"></span>
		<span><?php esc_html_e( 'Desktop', 'eltron' ); ?></span>
	</a>
	<a href="#" class="nav-tab preview-tablet preview-mobile eltron-responsive-switcher-button" data-device="tablet">
		<span class="dashicons dashicons-smartphone"></span>
		<span><?php esc_html_e( 'Tablet / Mobile', 'eltron' ); ?></span>
	</a>
</div>
<span class="button button-secondary eltron-builder-hide eltron-builder-toggle"><span class="dashicons dashicons-no"></span><?php esc_html_e( 'Hide', 'eltron' ); ?></span>
<span class="button button-primary eltron-builder-show eltron-builder-toggle"><span class="dashicons dashicons-edit"></span><?php esc_html_e( 'Header Builder', 'eltron' ); ?></span>
<?php $switcher = ob_get_clean();

// --- Blank: Header Builder Switcher
$wp_customize->add_control( new Eltron_Customize_Control_Blank( $wp_customize, 'header_builder_actions', array(
	'section'     => $section,
	'settings'    => array(),
	'description' => $switcher,
	'priority'    => 10,
) ) );

// Desktop Header
$key = 'header_elements';
$settings = array(
	'top_left'      => $key . '_top_left',
	'top_center'    => $key . '_top_center',
	'top_right'     => $key . '_top_right',
	'main_left'     => $key . '_main_left',
	'main_center'   => $key . '_main_center',
	'main_right'    => $key . '_main_right',
	'bottom_left'   => $key . '_bottom_left',
	'bottom_center' => $key . '_bottom_center',
	'bottom_right'  => $key . '_bottom_right',
);
foreach ( $settings as $setting ) {
	$wp_customize->add_setting( $setting, array(
		'default'     => eltron_array_value( $defaults, $setting ),
		'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'builder' ),
	) );
}
$wp_customize->add_control( new Eltron_Customize_Control_Builder( $wp_customize, $key, array(
	'settings'    => $settings,
	'section'     => $section,
	'label'       => esc_html__( 'Desktop Header', 'eltron' ),
	'choices'     => array(
		'logo'                   => '<span class="dashicons dashicons-admin-home"></span>' . esc_html__( 'Logo', 'eltron' ),
		/* translators: %s: instance number. */
		'menu-1'                 => '<span class="dashicons dashicons-admin-links"></span>' . sprintf( esc_html__( 'Menu %s', 'eltron' ), 1 ),
		/* translators: %s: instance number. */
		'html-1'                 => '<span class="dashicons dashicons-editor-code"></span>' . sprintf( esc_html__( 'HTML %s', 'eltron' ), 1 ),
		'search-bar'             => '<span class="dashicons dashicons-search"></span>' . esc_html__( 'Search Bar', 'eltron' ),
		'search-dropdown'        => '<span class="dashicons dashicons-search"></span>' . esc_html__( 'Search Dropdown', 'eltron' ),
		'shopping-cart-link'     => '<span class="dashicons dashicons-cart"></span>' . esc_html__( 'Cart Link', 'eltron' ),
		'shopping-cart-dropdown' => '<span class="dashicons dashicons-cart"></span>' . esc_html__( 'Cart Dropdown', 'eltron' ),
		'social'                 => '<span class="dashicons dashicons-twitter"></span>' . esc_html__( 'Social', 'eltron' ),
	),
	'labels'      => array(
		'top_left'      => is_rtl() ? esc_html__( 'Top - Right', 'eltron' ) : esc_html__( 'Top - Left', 'eltron' ),
		'top_center'    => esc_html__( 'Top - Center', 'eltron' ),
		'top_right'     => is_rtl() ? esc_html__( 'Top - Left', 'eltron' ) : esc_html__( 'Top - Right', 'eltron' ),
		'main_left'     => is_rtl() ? esc_html__( 'Main - Right', 'eltron' ) : esc_html__( 'Main - Left', 'eltron' ),
		'main_center'   => esc_html__( 'Main - Center', 'eltron' ),
		'main_right'    => is_rtl() ? esc_html__( 'Main - Left', 'eltron' ) : esc_html__( 'Main - Right', 'eltron' ),
		'bottom_left'   => is_rtl() ? esc_html__( 'Bottom - Right', 'eltron' ) : esc_html__( 'Bottom - Left', 'eltron' ),
		'bottom_center' => esc_html__( 'Bottom - Center', 'eltron' ),
		'bottom_right'  => is_rtl() ? esc_html__( 'Bottom - Left', 'eltron' ) : esc_html__( 'Bottom - Right', 'eltron' ),
	),
	'priority'    => 10,
) ) );

// Mobile Header
$key = 'header_mobile_elements';
$settings = array(
	'mobile_main_left'    => $key . '_main_left',
	'mobile_main_center'  => $key . '_main_center',
	'mobile_main_right'   => $key . '_main_right',
	'mobile_vertical_top' => $key . '_vertical_top',
);
foreach ( $settings as $setting ) {
	$wp_customize->add_setting( $setting, array(
		'default'     => eltron_array_value( $defaults, $setting ),
		'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'builder' ),
	) );
}
$wp_customize->add_control( new Eltron_Customize_Control_Builder( $wp_customize, $key, array(
	'settings'    => $settings,
	'section'     => $section,
	'label'       => esc_html__( 'Mobile Header', 'eltron' ),
	'choices'     => array(
		'mobile-logo'            => '<span class="dashicons dashicons-admin-home"></span>' . esc_html__( 'Mobile Logo', 'eltron' ),
		'mobile-menu'            => '<span class="dashicons dashicons-admin-links"></span>' . esc_html__( 'Mobile Menu', 'eltron' ),
		/* translators: %s: instance number. */
		'html-1'                 => '<span class="dashicons dashicons-editor-code"></span>' . sprintf( esc_html__( 'HTML %s', 'eltron' ), 1 ),
		'search-bar'             => '<span class="dashicons dashicons-search"></span>' . esc_html__( 'Search Bar', 'eltron' ),
		'search-dropdown'        => '<span class="dashicons dashicons-search"></span>' . esc_html__( 'Search Icon', 'eltron' ),
		'shopping-cart-link'     => '<span class="dashicons dashicons-cart"></span>' . esc_html__( 'Cart Link', 'eltron' ),
		'social'                 => '<span class="dashicons dashicons-twitter"></span>' . esc_html__( 'Social', 'eltron' ),
		'mobile-vertical-toggle' => '<span class="dashicons dashicons-menu"></span>' . esc_html__( 'Toggle', 'eltron' ),
	),
	'labels'      => array(
		'mobile_main_left'    => is_rtl() ? esc_html__( 'Right', 'eltron' ) : esc_html__( 'Left', 'eltron' ),
		'mobile_main_center'  => esc_html__( 'Center', 'eltron' ),
		'mobile_main_right'   => is_rtl() ? esc_html__( 'Left', 'eltron' ) : esc_html__( 'Right', 'eltron' ),
		'mobile_vertical_top' => esc_html__( 'Drawer (Popup)', 'eltron' ),
	),
	'limitations' => array(
		'mobile-logo'            => array( 'mobile_vertical_top' ),
		'mobile-menu'            => array( 'mobile_main_left', 'mobile_main_center', 'mobile_main_right' ),
		'search-bar'             => array( 'mobile_main_left', 'mobile_main_center', 'mobile_main_right' ),
		'search-dropdown'        => array( 'mobile_vertical_top' ),
		'shopping-cart-link'     => array( 'mobile_vertical_top' ),
		'mobile-vertical-toggle' => array( 'mobile_vertical_top' ),
	),
	'priority'    => 10,
) ) );