<?php
/**
 * Customizer settings: Blog > Single Post
 *
 * @package Eltron
 **/

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$section = 'eltron_section_blog_single';

/**
 * ====================================================
 * Additional Elements
 * ====================================================
 */

// Author bio
$key = 'blog_single_author_bio';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'toggle' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Toggle( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Show author bio', 'eltron' ),
	'priority'    => 10,
) ) );

// Prev / next posts navigation
$key = 'blog_single_navigation';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'toggle' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Toggle( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Show prev / next posts navigation', 'eltron' ),
	'priority'    => 10,
) ) );