<?php
/**
 * The template for displaying archive pages
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Eltron
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Header
 */
get_header();

/**
 * Primary - opening tag
 */
eltron_primary_open();

/**
 * Hook: eltron/frontend/before_main
 *
 * @hooked eltron_archive_header - 10
 */
do_action( 'eltron/frontend/before_main' );

if ( have_posts() ) :

	/**
	 * Hook: eltron/frontend/before_loop
	 */
	do_action( 'eltron/frontend/before_loop' );
	
	?>
		<section id="blog-page-area" class="blog-page-area-section">
				<div class="blog-page-content">
					<div class="row">
						<div id="loop" class="<?php echo esc_attr( implode( ' ', apply_filters( 'eltron/frontend/loop_classes', array( 'eltron-loop' ) ) ) ); ?>">
							<?php
							// Start the loop.
							while ( have_posts() ) : the_post();

								// Render post content using selected layout on Customizer.
								eltron_get_template_part( 'entry', eltron_get_theme_mod( 'blog_index_loop_mode' ) );

							endwhile;
							?>
						</div>
					</div>
				</div>
		</section>
	<?php

	/**
	 * Hook: eltron/frontend/after_loop
	 */
	do_action( 'eltron/frontend/after_loop' );

else :

	// Render no content notice.
	eltron_get_template_part( 'entry', 'none' );

endif;

/**
 * Hook: eltron/frontend/after_main
 * 
 * @hooked eltron_loop_navigation - 10
 */
do_action( 'eltron/frontend/after_main' );

/**
 * Primary - closing tag
 */
eltron_primary_close();

/**
 * Sidebar
 */
get_sidebar();

/**
 * Footer
 */
get_footer();